/*
 * Decompiled with CFR 0.152.
 */
package terrails.statskeeper.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import terrails.statskeeper.StatsKeeper;
import toughasnails.api.stat.IPlayerStat;
import toughasnails.api.stat.PlayerStatRegistry;

public class StatsMessageTAN
implements IMessage {
    private String capability;
    private NBTTagCompound compound;

    public StatsMessageTAN() {
    }

    public StatsMessageTAN(Capability<? extends IPlayerStat> capability, NBTTagCompound compound) {
        this.capability = capability.getName();
        this.compound = compound;
    }

    public void fromBytes(ByteBuf buf) {
        this.capability = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.compound = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.capability);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.compound);
    }

    public static class MessageHandler
    implements IMessageHandler<StatsMessageTAN, IMessage> {
        public IMessage onMessage(StatsMessageTAN message, MessageContext ctx) {
            if (ctx.side != Side.CLIENT) {
                return null;
            }
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                EntityPlayer player = StatsKeeper.proxy.getEntityPlayer();
                if (player != null) {
                    Capability capability = PlayerStatRegistry.getCapability((String)message.capability);
                    if (capability == null) {
                        return;
                    }
                    IPlayerStat stat = (IPlayerStat)player.getCapability(capability, null);
                    capability.getStorage().readNBT(capability, (Object)stat, null, (NBTBase)message.compound);
                }
            });
            return null;
        }
    }
}

