/*
 * Decompiled with CFR 0.152.
 */
package terrails.statskeeper.data.health;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import terrails.statskeeper.api.capabilities.IHealth;
import terrails.statskeeper.api.capabilities.SKCapabilities;
import terrails.statskeeper.config.configs.SKHealthConfig;
import terrails.statskeeper.data.health.HealthHandler;
import terrails.terracore.capabilities.CapabilitySerializable;

public class CapabilityHealth {
    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new Handler());
        CapabilityManager.INSTANCE.register(IHealth.class, (Capability.IStorage)new Capability.IStorage<IHealth>(){

            public NBTBase writeNBT(Capability<IHealth> capability, IHealth instance, EnumFacing side) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74757_a("sk:is_enabled", instance.isHealthEnabled());
                compound.func_74768_a("sk:additional_health", instance.getAdditionalHealth());
                compound.func_74768_a("sk:max_health", instance.getMaxHealth());
                compound.func_74768_a("sk:min_health", instance.getMinHealth());
                compound.func_74768_a("sk:starting_health", instance.getStartingHealth());
                compound.func_74768_a("sk:health_threshold", instance.getCurrentThreshold());
                return compound;
            }

            public void readNBT(Capability<IHealth> capability, IHealth instance, EnumFacing side, NBTBase nbt) {
                NBTTagCompound compound = (NBTTagCompound)nbt;
                if (compound.func_74764_b("sk:is_enabled")) {
                    instance.setHealthEnabled(compound.func_74767_n("sk:is_enabled"));
                }
                if (compound.func_74764_b("sk:starting_health")) {
                    instance.setStartingHealth(compound.func_74762_e("sk:starting_health"));
                }
                if (compound.func_74764_b("sk:additional_health")) {
                    instance.setAdditionalHealth(compound.func_74762_e("sk:additional_health"));
                }
                if (compound.func_74764_b("sk:max_health")) {
                    instance.setMaxHealth(compound.func_74762_e("sk:max_health"));
                }
                if (compound.func_74764_b("sk:min_health")) {
                    instance.setMinHealth(compound.func_74762_e("sk:min_health"));
                }
                if (compound.func_74764_b("sk:health_threshold")) {
                    instance.setCurrentThreshold(compound.func_74762_e("sk:health_threshold"));
                }
                if (compound.func_74764_b("addedHealth")) {
                    instance.setAdditionalHealth((int)compound.func_74769_h("addedHealth"));
                    instance.setStartingHealth(SKHealthConfig.starting_health);
                    instance.setMaxHealth(SKHealthConfig.max_health);
                    instance.setMinHealth(SKHealthConfig.min_health);
                    instance.setHealthEnabled(true);
                }
                if (compound.func_74764_b("sk:is_min_start")) {
                    boolean min_start = compound.func_74767_n("sk:is_min_start");
                    instance.setStartingHealth(min_start ? SKHealthConfig.min_health : SKHealthConfig.max_health);
                }
            }
        }, HealthHandler::new);
    }

    public static class Handler {
        @SubscribeEvent
        public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityPlayer) {
                event.addCapability(new ResourceLocation("stats_keeper", "Health"), (ICapabilityProvider)new CapabilitySerializable(SKCapabilities.HEALTH_CAPABILITY));
            }
        }
    }
}

