/*
 * Decompiled with CFR 0.152.
 */
package terrails.statskeeper.config;

import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import terrails.statskeeper.config.configs.SKHealthConfig;
import terrails.statskeeper.config.configs.SKHungerConfig;
import terrails.statskeeper.config.configs.SKTANConfig;

public class SKConfig {
    static Configuration configuration;
    public static boolean keep_experience;
    public static boolean drop_experience;

    @SubscribeEvent
    public void configChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("stats_keeper")) {
            SKConfig.syncConfig();
            SKConfig.syncPostConfig();
        }
    }

    public static void initialize(File directory) {
        configuration = new Configuration(new File(directory, "stats_keeper.cfg"));
        MinecraftForge.EVENT_BUS.register((Object)new SKConfig());
        SKConfig.syncConfig();
    }

    private static void syncConfig() {
        keep_experience = configuration.get("Basic", "Keep Experience", true).getBoolean();
        drop_experience = configuration.get("Basic", "Drop Experience", false).getBoolean();
        SKHealthConfig.init(configuration, "Health");
        SKHungerConfig.init(configuration, "Hunger");
        SKTANConfig.init(configuration, "Mod-Compatibility.ToughAsNails");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static void syncPostConfig() {
        SKHealthConfig.postInit(configuration, "Health");
    }

    static class Categories {
        static final String BASIC = "Basic";
        static final String HUNGER = "Hunger";
        static final String HEALTH = "Health";
        static final String MOD_COMP = "Mod-Compatibility";
        static final String TOUGH_AS_NAILS = "Mod-Compatibility.ToughAsNails";

        Categories() {
        }
    }
}

