/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gamestages.data;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.darkhax.bookshelf.util.NBTUtils;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.GameStages;
import net.darkhax.gamestages.config.Configuration;
import net.darkhax.gamestages.data.EmptyStageData;
import net.darkhax.gamestages.data.FakePlayerData;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.gamestages.data.StageData;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class GameStageSaveHandler {
    private static final Map<UUID, IStageData> GLOBAL_STAGE_DATA = new HashMap<UUID, IStageData>();
    private static final Map<String, FakePlayerData> FAKE_STAGE_DATA = new HashMap<String, FakePlayerData>();
    private static final File FAKE_PLAYER_STAGE_FILE = new File(new File("config"), "gameStagesFakePlayerData.json");
    private static final Gson GSON = new Gson();
    public static final IStageData EMPTY_STAGE_DATA = new EmptyStageData();
    @SideOnly(value=Side.CLIENT)
    public static IStageData clientData;

    @SubscribeEvent
    public static void onPlayerLoad(PlayerEvent.LoadFromFile event) {
        File playerFile = GameStageSaveHandler.getPlayerFile(event.getPlayerDirectory(), event.getPlayerUUID());
        StageData playerData = new StageData();
        if (playerFile.exists()) {
            try {
                NBTTagCompound tag = CompressedStreamTools.func_74797_a((File)playerFile);
                playerData.readFromNBT(tag);
                if (Configuration.debug.logDebug) {
                    GameStages.LOG.info("Loaded {} stages for {}.", new Object[]{playerData.getStages().size(), event.getEntityPlayer().func_70005_c_()});
                }
            }
            catch (IOException e) {
                GameStages.LOG.error("Could not read player data for {}.", new Object[]{event.getEntityPlayer().func_70005_c_()});
                GameStages.LOG.catching((Throwable)e);
            }
        } else {
            GameStageSaveHandler.handleLegacyData(event.getPlayerDirectory(), event.getPlayerUUID(), playerData);
        }
        GLOBAL_STAGE_DATA.put(event.getEntityPlayer().getPersistentID(), playerData);
    }

    @SubscribeEvent
    public static void onPlayerSave(PlayerEvent.SaveToFile event) {
        UUID playerUUID = event.getEntityPlayer().getPersistentID();
        if (GLOBAL_STAGE_DATA.containsKey(playerUUID)) {
            IStageData playerData = GameStageSaveHandler.getPlayerData(playerUUID);
            File playerFile = GameStageSaveHandler.getPlayerFile(event.getPlayerDirectory(), event.getPlayerUUID());
            NBTTagCompound tag = playerData.writeToNBT();
            if (tag != null) {
                try {
                    CompressedStreamTools.func_74795_b((NBTTagCompound)tag, (File)playerFile);
                    if (Configuration.debug.logDebug) {
                        GameStages.LOG.info("Saved {} stages for {}.", new Object[]{playerData.getStages().size(), event.getEntityPlayer().func_70005_c_()});
                    }
                }
                catch (IOException e) {
                    GameStages.LOG.error("Could not write player data for {}.", new Object[]{playerFile.getName()});
                    GameStages.LOG.catching((Throwable)e);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            GameStageHelper.syncPlayer((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            GLOBAL_STAGE_DATA.remove(event.player.getPersistentID());
        }
    }

    public static IStageData getPlayerData(UUID uuid) {
        return GLOBAL_STAGE_DATA.computeIfAbsent(uuid, playerUUID -> new StageData());
    }

    private static File getPlayerFile(File playerDir, String uuid) {
        File saveDir = new File(playerDir, "gamestages");
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        return new File(saveDir, uuid + ".dat");
    }

    private static void handleLegacyData(File playerDir, String uuid, IStageData modern) {
        File mainDataFile = new File(playerDir, uuid + ".dat");
        if (mainDataFile.exists()) {
            try (FileInputStream mainDataStream = new FileInputStream(mainDataFile);){
                NBTTagCompound legacyData;
                NBTTagCompound forgeCaps;
                NBTTagCompound mainData = CompressedStreamTools.func_74796_a((InputStream)mainDataStream);
                if (mainData != null && mainData.func_74764_b("ForgeCaps") && (forgeCaps = mainData.func_74775_l("ForgeCaps")) != null && forgeCaps.func_74764_b("gamestages:playerdata") && (legacyData = forgeCaps.func_74775_l("gamestages:playerdata")) != null && legacyData.func_74764_b("UnlockedStages")) {
                    Collection legacyStages = NBTUtils.readCollection(new ArrayList(), (NBTTagList)legacyData.func_150295_c("UnlockedStages", 8), stage -> stage);
                    for (String stage2 : legacyStages) {
                        GameStages.LOG.info("Restoring legacy stage {} for player {}.", new Object[]{stage2, uuid});
                        modern.addStage(stage2);
                    }
                }
            }
            catch (IOException e) {
                GameStages.LOG.error("Could not read main player data for {}.", new Object[]{mainDataFile.getName()});
                GameStages.LOG.catching((Throwable)e);
            }
        } else if (Configuration.debug.logDebug) {
            GameStages.LOG.info("Could not find legacy data for {}.", new Object[]{uuid});
        }
    }

    public static void reloadFakePlayers() {
        if (Configuration.debug.logDebug) {
            GameStages.LOG.info("Reloading fakeplayers stage data from {}.", new Object[]{FAKE_PLAYER_STAGE_FILE.getName()});
        }
        FAKE_STAGE_DATA.clear();
        if (!FAKE_PLAYER_STAGE_FILE.exists()) {
            return;
        }
        try (BufferedReader reader = Files.newReader((File)FAKE_PLAYER_STAGE_FILE, (Charset)Charsets.UTF_8);){
            FakePlayerData[] fakePlayers = (FakePlayerData[])GSON.fromJson((Reader)reader, FakePlayerData[].class);
            Arrays.stream(fakePlayers).forEach(GameStageSaveHandler::addFakePlayer);
        }
        catch (IOException e) {
            GameStages.LOG.error("Could not read {}.", new Object[]{FAKE_PLAYER_STAGE_FILE.getName()});
            GameStages.LOG.catching((Throwable)e);
        }
    }

    public static boolean hasFakePlayer(String fakePlayerName) {
        return FAKE_STAGE_DATA.containsKey(fakePlayerName);
    }

    public static void addFakePlayer(FakePlayerData data) {
        FAKE_STAGE_DATA.put(data.getFakePlayerName(), data);
        if (Configuration.debug.logDebug) {
            GameStages.LOG.info("Adding fakeplayer {} with gamestages {}", new Object[]{data.getFakePlayerName(), data.getStages()});
        }
    }

    public static void removeFakePlayer(String fakePlayerName) {
        FakePlayerData removedData = FAKE_STAGE_DATA.remove(fakePlayerName);
        if (removedData != null && Configuration.debug.logDebug) {
            GameStages.LOG.info("Removing fakeplayer {} with gamestages {}", new Object[]{fakePlayerName, removedData.getStages()});
        }
    }

    public static IStageData getFakeData(String fakePlayerName) {
        return FAKE_STAGE_DATA.getOrDefault(fakePlayerName, FakePlayerData.DEFAULT);
    }
}

