/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.tic.modifiers;

import crazypants.enderio.base.integration.tic.ITicModifierHandler;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.ModBeheading;

public class TicModifierHandler
implements ITicModifierHandler {
    @Nonnull
    public static final TicModifierHandler instance = new TicModifierHandler();
    @Nonnull
    public static final TicModifierHandler instanceWithoutModifiers = new TicModifierHandler(){

        @Override
        public int getBehadingLevel(@Nonnull ItemStack itemStack) {
            return 0;
        }
    };

    protected boolean isToolWithTrait(@Nonnull ItemStack itemStack, ITrait trait) {
        return TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)itemStack), (String)trait.getIdentifier());
    }

    protected int getModifierLevel(@Nonnull ItemStack itemStack, Modifier modifier) {
        NBTTagCompound tag = TinkerUtil.getModifierTag((ItemStack)itemStack, (String)modifier.getIdentifier());
        return ModifierNBT.readTag((NBTTagCompound)tag).level;
    }

    public int getBehadingLevel(@Nonnull ItemStack itemStack) {
        int level = this.getModifierLevel(itemStack, TinkerModifiers.modBeheading);
        if (level == 0) {
            level = this.getModifierLevel(itemStack, (Modifier)ModBeheading.CLEAVER_BEHEADING_MOD);
        }
        return level;
    }

    public boolean isTinkerItem(@Nonnull ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof TinkersItem;
    }

    public boolean isBroken(ItemStack itemStack) {
        return ToolHelper.isBroken((ItemStack)itemStack);
    }
}

