/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.tic.fluids;

import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.fluid.Fluids;
import crazypants.enderio.integration.tic.fluids.MoltenGlowstone;
import crazypants.enderio.integration.tic.queues.TicRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Glowstone {
    private static final ResourceLocation GLOWSTONE_TEX_STILL = new ResourceLocation("enderio:blocks/fluid_glowstone_still");
    private static final ResourceLocation GLOWSTONE_TEX_FLOWING = new ResourceLocation("enderio:blocks/fluid_glowstone_flow");
    private static Fluid fluid;

    public static void createFluid() {
        fluid = new Fluid("glowstone", GLOWSTONE_TEX_STILL, GLOWSTONE_TEX_FLOWING){

            public int getColor() {
                return -2130706433;
            }
        }.setUnlocalizedName("enderio.glowstone").setDensity(-500).setGaseous(true).setTemperature(1773).setViscosity(100);
        FluidRegistry.registerFluid((Fluid)fluid);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
    }

    public static Block createFluidBlock() {
        fluid.setLuminosity(Blocks.field_150426_aN.func_176223_P().func_185906_d());
        MoltenGlowstone block = new MoltenGlowstone(fluid, Material.field_151586_h, 16759902);
        block.setFluidStack(new FluidStack(FluidRegistry.getFluid((String)fluid.getName()), 1000));
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("fluid", fluid.getName());
        tag.func_74778_a("ore", "Glowstone");
        tag.func_74757_a("toolforge", true);
        FMLInterModComms.sendMessage((String)"tconstruct", (String)"integrateSmeltery", (NBTTagCompound)tag);
        return block;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderers() {
        Fluids.registerFluidBlockRendering((Fluid)fluid);
    }

    public static void registerGlowstoneRecipes() {
        Fluid f = FluidRegistry.getFluid((String)"glowstone");
        if (f != null) {
            TicRecipeHandler.instance.registerSmelterySmelting(new Things().add(Items.field_151114_aO), f, 250.0f);
            TicRecipeHandler.instance.registerSmelterySmelting(new Things().add(Blocks.field_150426_aN), f, 1000.0f);
            TicRecipeHandler.instance.registerBasinCasting(new Things().add(Blocks.field_150426_aN), new Things(), f, 1000);
        }
    }
}

