/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.util;

import com.tictim.ceu.enums.NumberType;
import com.tictim.ceu.util.Numbers;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Property;

public final class Ratio {
    public static final Pattern PATTERN = Pattern.compile("\\s*(\\d+)\\s*:\\s*(\\d+)\\s*");
    public static final Ratio RATIO_1_1 = new Ratio();
    public final BigInteger input;
    public final BigInteger output;
    private final double inputDouble;
    private final double outputDouble;
    private BigDecimal inputDecimal;
    private BigDecimal outputDecimal;
    private Ratio reverse;

    public static Ratio ratioOf(Property config, Ratio defaultValue) {
        Ratio ratio;
        String v = config.getString();
        Matcher m = PATTERN.matcher(v);
        boolean matches = m.matches();
        AtomicBoolean flag = new AtomicBoolean(!matches);
        if (matches) {
            BigInteger b;
            BigInteger a = Ratio.get(m.group(1), defaultValue.input, flag);
            BigInteger cd = a.gcd(b = Ratio.get(m.group(2), defaultValue.output, flag));
            if (cd.compareTo(BigInteger.ONE) != 0) {
                a = a.divide(cd);
                b = b.divide(cd);
                flag.set(true);
            }
            ratio = new Ratio(a, b);
        } else {
            ratio = defaultValue;
        }
        if (flag.get()) {
            config.setValue(ratio.toString());
        }
        return ratio;
    }

    private static BigInteger get(String v, BigInteger defaultValue, AtomicBoolean flag) {
        try {
            BigInteger i = new BigInteger(v);
            if (i.signum() != 1) {
                i = BigInteger.ONE;
                flag.set(true);
            }
            return i;
        }
        catch (NumberFormatException e) {
            flag.set(true);
            return defaultValue;
        }
    }

    public static Ratio ratioOf(NBTTagCompound nbt) {
        return Ratio.ratioOf(new BigInteger(nbt.func_74770_j("inputRatio")), new BigInteger(nbt.func_74770_j("outputRatio")));
    }

    public static Ratio ratioOf(long input, long output) {
        return Ratio.ratioOf(BigInteger.valueOf(input), BigInteger.valueOf(output));
    }

    public static Ratio ratioOf(BigInteger input, BigInteger output) {
        if (input.compareTo(output) == 0) {
            return RATIO_1_1;
        }
        BigInteger cd = input.gcd(output);
        if (cd.compareTo(BigInteger.ONE) != 0) {
            return new Ratio(input.divide(cd), output.divide(cd));
        }
        return new Ratio(input, output);
    }

    private Ratio() {
        this(BigInteger.ONE, BigInteger.ONE);
        this.reverse = this;
    }

    private Ratio(BigInteger input, BigInteger output) {
        this.input = input;
        this.inputDouble = this.input.doubleValue();
        this.output = output;
        this.outputDouble = this.output.doubleValue();
    }

    public BigInteger convert(long input) {
        return this.convert(BigInteger.valueOf(input));
    }

    public int convertToInt(long input) {
        return this.convertToInt(BigInteger.valueOf(input));
    }

    public long convertToLong(long input) {
        return this.convertToLong(BigInteger.valueOf(input));
    }

    public double convertToDouble(long input) {
        return this.convertToDouble(BigInteger.valueOf(input));
    }

    public BigDecimal convertToDecimal(long input) {
        return this.convertToDecimal(new BigDecimal(input));
    }

    public Number convert(long input, NumberType type) {
        return this.convert(BigInteger.valueOf(input), type);
    }

    public BigInteger convert(double input) {
        return this.convertToDecimal(input).toBigInteger();
    }

    public int convertToInt(double input) {
        return Numbers.toInt(this.convertToDouble(input));
    }

    public long convertToLong(double input) {
        return Numbers.toLong(this.convertToDouble(input));
    }

    public double convertToDouble(double input) {
        return this == RATIO_1_1 ? input : Ratio.convertDouble(input, this.inputDouble, this.outputDouble);
    }

    public BigDecimal convertToDecimal(double input) {
        return this.convertToDecimal(new BigDecimal(input));
    }

    public Number convert(double input, NumberType type) {
        switch (type) {
            case INTEGER: {
                return this.convertToInt(input);
            }
            case LONG: {
                return this.convertToLong(input);
            }
            case BIG_INTEGER: {
                return this.convert(input);
            }
            case DOUBLE: {
                return this.convertToDouble(input);
            }
            case BIG_DECIMAL: {
                return this.convertToDecimal(input);
            }
        }
        throw new IllegalArgumentException();
    }

    public BigInteger convert(BigInteger input) {
        return this == RATIO_1_1 ? input : Ratio.convert(input, this.input, this.output);
    }

    public int convertToInt(BigInteger input) {
        return Numbers.toInt(this.convert(input));
    }

    public long convertToLong(BigInteger input) {
        return Numbers.toLong(this.convert(input));
    }

    public double convertToDouble(BigInteger input) {
        return this.convert(input).doubleValue();
    }

    public BigDecimal convertToDecimal(BigInteger input) {
        return this.convertToDecimal(new BigDecimal(input));
    }

    public Number convert(BigInteger input, NumberType type) {
        switch (type) {
            case INTEGER: {
                return this.convertToInt(input);
            }
            case LONG: {
                return this.convertToLong(input);
            }
            case BIG_INTEGER: {
                return this.convert(input);
            }
            case DOUBLE: {
                return this.convertToDouble(input);
            }
            case BIG_DECIMAL: {
                return this.convertToDecimal(input);
            }
        }
        throw new IllegalArgumentException();
    }

    public BigInteger convert(BigDecimal input) {
        return this.convertToDecimal(input).toBigInteger();
    }

    public int convertToInt(BigDecimal input) {
        return Numbers.toInt(this.convertToDouble(input));
    }

    public long convertToLong(BigDecimal input) {
        return Numbers.toLong(this.convertToDouble(input));
    }

    public double convertToDouble(BigDecimal input) {
        return this.convertToDecimal(input).doubleValue();
    }

    public BigDecimal convertToDecimal(BigDecimal input) {
        if (this == RATIO_1_1) {
            return input;
        }
        if (this.inputDecimal == null) {
            this.inputDecimal = new BigDecimal(this.input);
            this.outputDecimal = new BigDecimal(this.output);
        }
        return Ratio.convertDecimal(input, this.inputDecimal, this.outputDecimal);
    }

    public Number convert(BigDecimal input, NumberType type) {
        switch (type) {
            case INTEGER: {
                return this.convertToInt(input);
            }
            case LONG: {
                return this.convertToLong(input);
            }
            case BIG_INTEGER: {
                return this.convert(input);
            }
            case DOUBLE: {
                return this.convertToDouble(input);
            }
            case BIG_DECIMAL: {
                return this.convertToDecimal(input);
            }
        }
        throw new IllegalArgumentException();
    }

    public BigInteger convert(Number input) {
        switch (NumberType.of(input)) {
            case INTEGER: {
                return this.convert(input.intValue());
            }
            case LONG: {
                return this.convert(input.longValue());
            }
            case BIG_INTEGER: {
                return this.convert((BigInteger)input);
            }
            case DOUBLE: {
                return this.convert(input.doubleValue());
            }
            case BIG_DECIMAL: {
                return this.convert((BigDecimal)input);
            }
        }
        throw new IllegalArgumentException();
    }

    public int convertToInt(Number input) {
        switch (NumberType.of(input)) {
            case INTEGER: {
                return this.convertToInt(input.intValue());
            }
            case LONG: {
                return this.convertToInt(input.longValue());
            }
            case BIG_INTEGER: {
                return this.convertToInt((BigInteger)input);
            }
            case DOUBLE: {
                return this.convertToInt(input.doubleValue());
            }
            case BIG_DECIMAL: {
                return this.convertToInt((BigDecimal)input);
            }
        }
        throw new IllegalArgumentException();
    }

    public long convertToLong(Number input) {
        switch (NumberType.of(input)) {
            case INTEGER: {
                return this.convertToLong(input.intValue());
            }
            case LONG: {
                return this.convertToLong(input.longValue());
            }
            case BIG_INTEGER: {
                return this.convertToLong((BigInteger)input);
            }
            case DOUBLE: {
                return this.convertToLong(input.doubleValue());
            }
            case BIG_DECIMAL: {
                return this.convertToLong((BigDecimal)input);
            }
        }
        throw new IllegalArgumentException();
    }

    public double convertToDouble(Number input) {
        switch (NumberType.of(input)) {
            case INTEGER: {
                return this.convertToDouble(input.intValue());
            }
            case LONG: {
                return this.convertToDouble(input.longValue());
            }
            case BIG_INTEGER: {
                return this.convertToDouble((BigInteger)input);
            }
            case DOUBLE: {
                return this.convertToDouble(input.doubleValue());
            }
            case BIG_DECIMAL: {
                return this.convertToDouble((BigDecimal)input);
            }
        }
        throw new IllegalArgumentException();
    }

    public BigDecimal convertToDecimal(Number input) {
        switch (NumberType.of(input)) {
            case INTEGER: {
                return this.convertToDecimal(input.intValue());
            }
            case LONG: {
                return this.convertToDecimal(input.longValue());
            }
            case BIG_INTEGER: {
                return this.convertToDecimal((BigInteger)input);
            }
            case DOUBLE: {
                return this.convertToDecimal(input.doubleValue());
            }
            case BIG_DECIMAL: {
                return this.convertToDecimal((BigDecimal)input);
            }
        }
        throw new IllegalArgumentException();
    }

    public Number convert(Number input, NumberType type) {
        switch (NumberType.of(input)) {
            case INTEGER: {
                return this.convert(input.intValue(), type);
            }
            case LONG: {
                return this.convert(input.longValue(), type);
            }
            case BIG_INTEGER: {
                return this.convert((BigInteger)input, type);
            }
            case DOUBLE: {
                return this.convert(input.doubleValue(), type);
            }
            case BIG_DECIMAL: {
                return this.convert((BigDecimal)input, type);
            }
        }
        throw new IllegalArgumentException();
    }

    public Ratio reverse() {
        if (this.reverse == null) {
            this.reverse = new Ratio(this.output, this.input);
            this.reverse.reverse = this;
        }
        return this.reverse;
    }

    public void serialize(NBTTagCompound nbt) {
        nbt.func_74773_a("inputRatio", this.input.toByteArray());
        nbt.func_74773_a("outputRatio", this.output.toByteArray());
    }

    public String toString() {
        return this.input + ":" + this.output;
    }

    private static BigInteger convert(BigInteger value, BigInteger ratioA, BigInteger ratioB) {
        return value.multiply(ratioB).divide(ratioA);
    }

    private static double convertDouble(double value, double ratioA, double ratioB) {
        return value * ratioB / ratioA;
    }

    private static BigDecimal convertDecimal(BigDecimal value, BigDecimal ratioA, BigDecimal ratioB) {
        return value.multiply(ratioB).divide(ratioA, MathContext.DECIMAL64);
    }
}

