/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.mte.trait.charger;

import com.tictim.ceu.config.CeuConfig;
import com.tictim.ceu.energy.CeuCharger;
import com.tictim.ceu.mte.MTECeu;
import com.tictim.ceu.util.Numbers;
import com.tictim.ceu.util.Ratio;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class ChargeHandler
extends MTETrait
implements CeuCharger {
    protected final MTECeu ceu;

    public ChargeHandler(MTECeu ceu) {
        super((MetaTileEntity)ceu);
        this.ceu = ceu;
    }

    public String getName() {
        return "CeuChargeHandler";
    }

    public int getNetworkID() {
        return -1;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability) {
        return null;
    }

    public void update() {
        if (!this.ceu.getWorld().field_72995_K && this.ceu.isThisEnabled()) {
            Ratio r = this.ceu.ratio();
            Number charged = r.reverse().convert(this.insertEnergy(this.ceu.getType().getOutput(), r.convert(this.ceu.extractEnergy(this.ceu.getType().getInput(), Long.MAX_VALUE, false, true), this.ceu.getType().getOutput().getNumberType()), false, false), this.ceu.getType().getInput().getNumberType());
            this.ceu.extractEnergy(this.ceu.getType().getInput(), charged, false, false);
            if (this.ceu.getEnergyStorage().getEnergyStored() > 0L) {
                if (this.ceu.isCeu()) {
                    this.ceu.getEnergyStorage().removeEnergy(this.chargeEU(this.ceu.getEnergyStorage().getEnergyStored(), false, false, false));
                } else {
                    this.ceu.getEnergyStorage().removeEnergy(r.convertToLong(this.insertEnergy(this.ceu.getType().getInput(), r.reverse().convert(this.ceu.getEnergyStorage().getEnergyStored(), this.ceu.getType().getInput().getNumberType()), false, false)));
                }
            }
        }
    }

    public long chargeEU(long amount, boolean ignoreLimit, boolean chargeWrapped, boolean simulate) {
        if (amount <= 0L) {
            return 0L;
        }
        long total = 0L;
        IItemHandlerModifiable inventory = this.ceu.getImportItems();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            IElectricItem item;
            ItemStack s = inventory.getStackInSlot(i);
            if (s.func_190926_b() || (item = this.getBatteryContainer(s, chargeWrapped)) == null || (total += item.charge(amount - total, item.getTier(), ignoreLimit, simulate)) < amount) continue;
            return amount;
        }
        return total;
    }

    public long dischargeEU(long amount, boolean ignoreLimit, boolean externally, boolean dischargeWrapped, boolean simulate) {
        if (amount <= 0L) {
            return 0L;
        }
        long total = 0L;
        IItemHandlerModifiable inventory = this.ceu.getImportItems();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            IElectricItem item;
            ItemStack s = inventory.getStackInSlot(i);
            if (s.func_190926_b() || (item = this.getBatteryContainer(s, dischargeWrapped)) == null || (total += item.discharge(amount - total, item.getTier(), ignoreLimit, externally, simulate)) < amount) continue;
            return amount;
        }
        return total;
    }

    public long capacityEU(boolean includeWrapped) {
        long total = 0L;
        IItemHandlerModifiable inventory = this.ceu.getImportItems();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            IElectricItem item;
            ItemStack s = inventory.getStackInSlot(i);
            if (s.func_190926_b() || (item = this.getBatteryContainer(s, includeWrapped)) == null || (total = Numbers.addWithOverflowCheck(item.getMaxCharge(), total)) != Long.MAX_VALUE) continue;
            return total;
        }
        return total;
    }

    public long storedEU(boolean includeWrapped) {
        long total = 0L;
        IItemHandlerModifiable inventory = this.ceu.getImportItems();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            IElectricItem item;
            ItemStack s = inventory.getStackInSlot(i);
            if (s.func_190926_b() || (item = this.getBatteryContainer(s, includeWrapped)) == null || (total = Numbers.addWithOverflowCheck(item.getCharge(), total)) != Long.MAX_VALUE) continue;
            return total;
        }
        return total;
    }

    @Nullable
    public IElectricItem getBatteryContainer(ItemStack s, boolean wrap) {
        IElectricItem i = (IElectricItem)s.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (i != null && i.canProvideChargeExternally()) {
            return CeuConfig.instance().permitOnlyExactVoltage() && i.getTier() != this.ceu.getTier() ? null : i;
        }
        if (wrap) {
            return this.getWrappedBatteryContainer(s);
        }
        return null;
    }

    @Nullable
    protected abstract IElectricItem getWrappedBatteryContainer(ItemStack var1);
}

