/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.mte;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.tictim.ceu.CeuResources;
import com.tictim.ceu.energy.CeuCharger;
import com.tictim.ceu.energy.UniversalEnergyStorage;
import com.tictim.ceu.enums.CeuType;
import com.tictim.ceu.enums.ConverterType;
import com.tictim.ceu.enums.Energy;
import com.tictim.ceu.mte.trait.charger.ChargeHandler;
import com.tictim.ceu.util.Numbers;
import com.tictim.ceu.util.Ratio;
import gregtech.api.GTValues;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.render.SimpleOverlayRenderer;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class MTECeu
extends TieredMetaTileEntity
implements CeuCharger {
    protected final CeuType type;
    protected final int size;
    protected final int invSize;
    private UniversalEnergyStorage energyStorage;
    private ChargeHandler itemChargeHandler;

    public MTECeu(ResourceLocation id, int tier, CeuType type, int size) {
        super(id, tier);
        this.type = type;
        this.size = size;
        this.invSize = size * size;
        this.reinitializeEnergyContainer();
        this.initializeInventory();
    }

    public UniversalEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public ChargeHandler getChargeHandler() {
        return this.itemChargeHandler;
    }

    public CeuType getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public long getEUStoredSum(boolean includeWrapped) {
        return Numbers.addWithOverflowCheck(this.getChargeHandler().storedEU(includeWrapped), this.getEnergyStorage().getEnergyStored());
    }

    public long getEUCapacitySum(boolean includeWrapped) {
        return Numbers.addWithOverflowCheck(this.getChargeHandler().capacityEU(includeWrapped), this.getEnergyStorage().getEnergyCapacity());
    }

    public long extractEU(long max, boolean includeWrapped, boolean simulate) {
        if (max <= 0L) {
            return 0L;
        }
        long usage = this.getChargeHandler().dischargeEU(max, false, true, includeWrapped, simulate);
        if (max > usage) {
            usage += simulate ? Math.min(this.getEnergyStorage().getEnergyStored(), max - usage) : Math.abs(this.getEnergyStorage().removeEnergy(max - usage));
        }
        return usage;
    }

    public long insertEU(long max, boolean includeWrapped, boolean simulate) {
        if (max <= 0L) {
            return 0L;
        }
        long inserted = this.getChargeHandler().chargeEU(max, false, includeWrapped, simulate);
        if (max > inserted) {
            inserted += simulate ? Math.min(this.getEnergyStorage().getEnergyCapacity() - this.getEnergyStorage().getEnergyStored(), max - inserted) : this.getEnergyStorage().addEnergy(max - inserted);
        }
        return inserted;
    }

    @Override
    public Number getStoredSum(Energy e, boolean includeWrapped) {
        if (e == Energy.GTEU) {
            return this.getEUStoredSum(includeWrapped);
        }
        if (e != this.type.getConverterType().getCeuOutput()) {
            throw new IllegalArgumentException();
        }
        return Numbers.addWithOverflowCheck(this.getChargeHandler().getStoredSum(e, includeWrapped), this.ratioGteuAsInput().convert(this.getEnergyStorage().getEnergyStored(), e.getNumberType()));
    }

    @Override
    public Number getCapacitySum(Energy e, boolean includeWrapped) {
        if (e == Energy.GTEU) {
            return this.getEUCapacitySum(includeWrapped);
        }
        if (e != this.type.getConverterType().getCeuOutput()) {
            throw new IllegalArgumentException();
        }
        return Numbers.addWithOverflowCheck(this.getChargeHandler().getCapacitySum(e, includeWrapped), this.ratioGteuAsInput().convert(this.getEnergyStorage().getEnergyCapacity(), e.getNumberType()));
    }

    @Override
    public Number extractEnergy(Energy e, Number max, boolean extractWrapped, boolean simulate) {
        if (e == Energy.GTEU) {
            return this.extractEU(max.longValue(), extractWrapped, simulate);
        }
        if (e != this.type.getConverterType().getCeuOutput()) {
            throw new IllegalArgumentException();
        }
        Number n = this.getChargeHandler().extractEnergy(e, max, extractWrapped, simulate);
        return Numbers.addWithOverflowCheck(n, this.ratioGteuAsInput().convert(this.getEnergyStorage().asElectricItem().discharge(this.ratioGteuAsOutput().convertToLong(Numbers.sub(max, n)), this.getTier(), true, false, simulate), e.getNumberType()));
    }

    @Override
    public Number insertEnergy(Energy e, Number max, boolean insertWrapped, boolean simulate) {
        if (e == Energy.GTEU) {
            return this.insertEU(max.longValue(), insertWrapped, simulate);
        }
        if (e != this.type.getConverterType().getCeuOutput()) {
            throw new IllegalArgumentException();
        }
        Number n = this.getChargeHandler().insertEnergy(e, max, insertWrapped, simulate);
        return Numbers.addWithOverflowCheck(n, this.ratioGteuAsInput().convert(this.getEnergyStorage().asElectricItem().charge(this.ratioGteuAsOutput().convertToLong(Numbers.sub(max, n)), this.getTier(), true, simulate), e.getNumberType()));
    }

    public Ratio ratio() {
        return this.getType().ratio(this.getTier());
    }

    public Ratio ratioGteuAsInput() {
        return this.isCeu() ? this.ratio() : this.ratio().reverse();
    }

    public Ratio ratioGteuAsOutput() {
        return this.isCeu() ? this.ratio().reverse() : this.ratio();
    }

    public boolean isThisEnabled() {
        return !this.getType().isDisabled(this.getTier());
    }

    public boolean isCeu() {
        return this.type.isCeu();
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        ((SimpleOverlayRenderer)CeuResources.CEU_FACES.get((Object)this.type)).renderSided(this.getFrontFacing(), renderState, translation, pipeline);
    }

    protected void reinitializeEnergyContainer() {
        if (this.type == null) {
            return;
        }
        this.energyStorage = new UniversalEnergyStorage(this, GTValues.V[this.getTier()] * 32L);
        this.type.getInput().createEnergyReceiverTrait(this);
        this.type.getOutput().createEnergyEmitterTrait(this);
        this.itemChargeHandler = this.type.getConverterType().getCeuOutput().createChargeHandler(this);
        this.updateComparatorValue();
    }

    public int getActualComparatorValue() {
        long energyStored = this.energyStorage.getEnergyStored();
        long energyCapacity = this.energyStorage.getEnergyCapacity();
        float f = energyCapacity == 0L ? 0.0f : (float)energyStored / (float)energyCapacity;
        return MathHelper.func_76141_d((float)(f * 14.0f)) + (energyStored > 0L ? 1 : 0);
    }

    protected boolean isEnergyEmitter() {
        return !this.isCeu();
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"ceu.description", (Object[])new Object[]{this.type.getInput(), this.type.getOutput()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.item_storage_capacity", (Object[])new Object[]{this.invSize}));
        if (this.getType().isDisabled(this.getTier())) {
            tooltip.add(I18n.func_135052_a((String)"ceu.disabled", (Object[])new Object[0]));
        } else if (this.getType().getConverterType() == ConverterType.ICEU_ICEF) {
            tooltip.add(I18n.func_135052_a((String)"ceu.disabled.ic2", (Object[])new Object[0]));
        } else {
            if (this.type.getInput() == Energy.GTEU) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{this.energyStorage.getInputVoltage(), GTValues.VN[this.getTier()]}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_out", (Object[])new Object[]{this.energyStorage.getOutputVoltage(), GTValues.VN[this.getTier()]}));
            }
            tooltip.add(I18n.func_135052_a((String)(this.isCeu() ? "ceu.energy_out" : "ceu.energy_in"), (Object[])new Object[]{this.type.getConverterType().getCeuOutput(), this.ratioGteuAsInput().convert(GTValues.V[this.getTier()] * (long)this.invSize, this.type.getConverterType().getCeuOutput().getNumberType())}));
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyStorage.getEnergyCapacity()}));
        }
    }

    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MTECeu(this.metaTileEntityId, this.getTier(), this.type, this.size);
    }

    public boolean isValidFrontFacing(EnumFacing facing) {
        return true;
    }

    protected IItemHandlerModifiable createImportItemHandler() {
        return new ItemStackHandler(this.invSize){

            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (MTECeu.this.itemChargeHandler.getBatteryContainer(stack, true) == null) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    protected IItemHandlerModifiable createExportItemHandler() {
        return new EmptyHandler();
    }

    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder b = ModularUI.builder((TextureArea)GuiTextures.BACKGROUND, (int)176, (int)(18 + 18 * this.size + 94)).label(10, 5, this.getMetaFullName());
        for (int y = 0; y < this.size; ++y) {
            for (int x = 0; x < this.size; ++x) {
                int index = y * this.size + x;
                b.widget((Widget)new SlotWidget(this.importItems, index, 89 - this.size * 9 + x * 18, 18 + y * 18, true, true).setBackgroundTexture(new TextureArea[]{GuiTextures.SLOT, GuiTextures.BATTERY_OVERLAY}));
            }
        }
        return b.bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.SLOT, 8, 18 + 18 * this.size + 12).build((IUIHolder)this.getHolder(), entityPlayer);
    }

    @Nullable
    public <T> T getCapability(Capability<T> cap, EnumFacing side) {
        if (cap == null) {
            return null;
        }
        if (cap == this.type.getInput().getCapability()) {
            return (T)(this.getFrontFacing() != side ? super.getCapability(cap, side) : null);
        }
        if (cap == this.type.getOutput().getCapability()) {
            return (T)(this.getFrontFacing() == side ? super.getCapability(cap, side) : null);
        }
        return (T)super.getCapability(cap, side);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("EnergyStorage", (NBTBase)this.energyStorage.serializeNBT());
        return data;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.energyStorage.deserializeNBT(data.func_74775_l("EnergyStorage"));
    }
}

