/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.energy;

import com.tictim.ceu.mte.MTECeu;
import com.tictim.ceu.util.Numbers;
import gregtech.api.GTValues;
import gregtech.api.capability.IElectricItem;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class UniversalEnergyStorage
implements IEnergyContainer,
INBTSerializable<NBTTagCompound> {
    private final MTECeu ceu;
    private long current;
    private long max;
    private final ElectricItemWrapped electricItem = new ElectricItemWrapped();

    public UniversalEnergyStorage(MTECeu ceu, long max) {
        this(ceu, 0L, max);
    }

    public UniversalEnergyStorage(MTECeu ceu, long current, long max) {
        this.ceu = ceu;
        this.current = current;
        this.max = max;
    }

    public IElectricItem asElectricItem() {
        return this.electricItem;
    }

    public long acceptEnergyFromNetwork(@Nullable EnumFacing side, long voltage, long amperage) {
        if (voltage > 0L && amperage > 0L && (side == null || this.inputsEnergy(side))) {
            long amperesAccepted;
            if (voltage > this.getInputVoltage()) {
                BlockPos pos = this.ceu.getPos();
                this.ceu.getWorld().func_175698_g(pos);
                if (ConfigHolder.doExplosions) {
                    this.ceu.getWorld().func_72876_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (float)GTUtility.getTierByVoltage((long)voltage), true);
                }
                return Math.min(amperage, this.getInputAmperage());
            }
            long canAccept = this.getEnergyCapacity() - this.getEnergyStored();
            if (canAccept >= voltage && (amperesAccepted = Math.min(canAccept / voltage, Math.min(amperage, this.getInputAmperage()))) > 0L) {
                this.setEnergyStored(this.getEnergyStored() + voltage * amperesAccepted);
                return amperesAccepted;
            }
        }
        return 0L;
    }

    public boolean inputsEnergy(EnumFacing side) {
        return this.ceu.isCeu() && this.ceu.getFrontFacing() != side;
    }

    public long changeEnergy(long differenceAmount) {
        long old = this.current;
        this.current = Numbers.clamp(this.current + differenceAmount, 0L, this.max);
        return old - this.current;
    }

    public void setEnergyStored(long value) {
        this.current = Numbers.clamp(value, 0L, this.max);
    }

    public long getEnergyStored() {
        return this.current;
    }

    public long getEnergyCapacity() {
        return this.max;
    }

    public long getInputAmperage() {
        return this.ceu.getImportItems().getSlots();
    }

    public long getOutputAmperage() {
        return this.getInputAmperage();
    }

    public long getInputVoltage() {
        return GTValues.V[this.ceu.getTier()];
    }

    public long getOutputVoltage() {
        return this.getInputVoltage();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74772_a("current", this.current);
        nbt.func_74772_a("max", this.max);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.current = nbt.func_74763_f("current");
        this.max = nbt.func_74763_f("max");
    }

    private class ElectricItemWrapped
    implements IElectricItem {
        private ElectricItemWrapped() {
        }

        public boolean canProvideChargeExternally() {
            return false;
        }

        public void addChargeListener(BiConsumer<ItemStack, Long> chargeListener) {
        }

        public long charge(long amount, int chargerTier, boolean ignoreTransferLimit, boolean simulate) {
            if (amount > 0L) {
                long added = Math.min(amount, UniversalEnergyStorage.this.max - UniversalEnergyStorage.this.current);
                if (ignoreTransferLimit) {
                    added = Math.min(added, UniversalEnergyStorage.this.getInputAmperage() * UniversalEnergyStorage.this.getInputVoltage());
                }
                if (added > 0L) {
                    if (!simulate) {
                        UniversalEnergyStorage.this.addEnergy(added);
                    }
                    return added;
                }
            }
            return 0L;
        }

        public long discharge(long amount, int dischargerTier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
            if (amount > 0L) {
                long consumed = Math.min(amount, UniversalEnergyStorage.this.current);
                if (ignoreTransferLimit) {
                    consumed = Math.min(consumed, UniversalEnergyStorage.this.getInputAmperage() * UniversalEnergyStorage.this.getInputVoltage());
                }
                if (consumed > 0L) {
                    if (!simulate) {
                        UniversalEnergyStorage.this.removeEnergy(consumed);
                    }
                    return consumed;
                }
            }
            return 0L;
        }

        public long getMaxCharge() {
            return UniversalEnergyStorage.this.max;
        }

        public long getCharge() {
            return UniversalEnergyStorage.this.current;
        }

        public int getTier() {
            return UniversalEnergyStorage.this.ceu.getTier();
        }
    }
}

