/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu;

import com.google.common.collect.ImmutableMap;
import com.tictim.ceu.enums.CeuType;
import com.tictim.ceu.enums.Energy;
import gregtech.api.render.SimpleOverlayRenderer;

public final class CeuResources {
    public static final ImmutableMap<CeuType, SimpleOverlayRenderer> CEU_FACES;
    public static final ImmutableMap<Energy, SimpleOverlayRenderer> EMITTER_FACES;
    public static final ImmutableMap<Energy, SimpleOverlayRenderer> RECEIVER_FACES;

    private CeuResources() {
    }

    public static void init() {
    }

    static {
        ImmutableMap.Builder b = new ImmutableMap.Builder();
        for (CeuType t : CeuType.values()) {
            b.put((Object)t, (Object)new SimpleOverlayRenderer("overlay/machine/ceu/" + t.toString().toLowerCase()));
        }
        CEU_FACES = b.build();
        b = new ImmutableMap.Builder();
        ImmutableMap.Builder b2 = new ImmutableMap.Builder();
        for (Energy e : Energy.values()) {
            b.put((Object)e, (Object)new SimpleOverlayRenderer("overlay/machine/ceu/" + e.getRawName() + "_emitter"));
            b2.put((Object)e, (Object)new SimpleOverlayRenderer("overlay/machine/ceu/" + e.getRawName() + "_receiver"));
        }
        EMITTER_FACES = b.build();
        RECEIVER_FACES = b2.build();
    }
}

