/*
 * Decompiled with CFR 0.152.
 */
package me.yrf.mcmods.capadapter.ae2;

import appeng.api.exceptions.FailedConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHelper;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.yrf.mcmods.capadapter.CapabilityAdapterAEPlugin;
import me.yrf.mcmods.capadapter.ae2.IAEGridProxyCapability;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileAECapAdapter
extends TileEntity
implements IGridHost,
ITickable {
    @CapabilityInject(value=IAEGridProxyCapability.class)
    private static Capability<IAEGridProxyCapability> GridProxyCapability;
    private final AEGridProxy gridProxy = new AEGridProxy();
    private IGridNode node;
    private IAEGridProxyCapability cap = new ProxyCapability();
    private short tickCounter = 0;
    private ConcurrentHashMap<IGridNode, IGridConnection> capabilityNodes = new ConcurrentHashMap();
    private Set<IGridNode> searchSet = new HashSet<IGridNode>(6);

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == GridProxyCapability || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == GridProxyCapability ? this.cap : super.getCapability(capability, facing));
    }

    public void setPlayer(EntityPlayer player) {
        if (player == null) {
            return;
        }
        int id = CapabilityAdapterAEPlugin.INSTANCE.api.registries().players().getID(player);
        this.node.setPlayerID(id);
    }

    public void onBlockUpdate() {
        this.node.updateState();
        this.updateConnectedNodes();
    }

    public void updateConnectedNodes() {
        for (EnumFacing f : EnumFacing.field_82609_l) {
            IAEGridProxyCapability remoteCap;
            TileEntity te;
            BlockPos pos = this.func_174877_v().func_177972_a(f);
            if (!this.field_145850_b.func_175667_e(pos) || (te = this.field_145850_b.func_175625_s(pos)) == null || !te.hasCapability(GridProxyCapability, f.func_176734_d()) || te instanceof IGridHost || (remoteCap = (IAEGridProxyCapability)te.getCapability(GridProxyCapability, f.func_176734_d())) == null || remoteCap.getProxiedObject() == null || remoteCap.getProxiedObject() == this.node) continue;
            this.searchSet.add((IGridNode)remoteCap.getProxiedObject());
        }
        if (!this.capabilityNodes.isEmpty()) {
            for (IGridNode n : this.capabilityNodes.keySet()) {
                if (this.searchSet.contains(n)) continue;
                IGridConnection conn = this.capabilityNodes.remove(n);
                if (!this.node.getConnections().contains((Object)conn)) continue;
                conn.destroy();
            }
        }
        IGridHelper gh = CapabilityAdapterAEPlugin.INSTANCE.api.grid();
        for (IGridNode remoteNode : this.searchSet) {
            if (this.capabilityNodes.containsKey(remoteNode)) continue;
            try {
                IGridConnection conn = gh.createGridConnection(this.node, remoteNode);
                this.capabilityNodes.put(remoteNode, conn);
            }
            catch (FailedConnectionException failedConnectionException) {}
        }
        this.searchSet.clear();
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.node = CapabilityAdapterAEPlugin.INSTANCE.api.grid().createGridNode((IGridBlock)this.gridProxy);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.node.destroy();
            this.node = null;
        }
    }

    public void onChunkUnload() {
        this.node.destroy();
        super.onChunkUnload();
    }

    public void onLoad() {
        this.node.updateState();
    }

    public IGridNode getGridNode(AEPartLocation aePartLocation) {
        return this.node;
    }

    public AECableType getCableConnectionType(AEPartLocation aePartLocation) {
        return AECableType.SMART;
    }

    public void securityBreak() {
    }

    public void func_73660_a() {
        if (this.tickCounter == 0) {
            this.updateConnectedNodes();
            this.tickCounter = (short)(this.tickCounter + 1);
        } else {
            this.tickCounter = (short)(this.tickCounter + 1);
        }
        if (this.tickCounter == 60) {
            this.tickCounter = 0;
        }
    }

    private class AEGridProxy
    implements IGridBlock {
        private ItemStack display;

        private AEGridProxy() {
        }

        public double getIdlePowerUsage() {
            return 1.0;
        }

        public EnumSet<GridFlags> getFlags() {
            return EnumSet.noneOf(GridFlags.class);
        }

        public boolean isWorldAccessible() {
            return true;
        }

        public DimensionalCoord getLocation() {
            return new DimensionalCoord(TileAECapAdapter.this.func_145831_w(), TileAECapAdapter.this.func_174877_v());
        }

        public AEColor getGridColor() {
            return AEColor.TRANSPARENT;
        }

        public void onGridNotification(GridNotification gridNotification) {
        }

        public void setNetworkStatus(IGrid iGrid, int i) {
        }

        public EnumSet<EnumFacing> getConnectableSides() {
            return EnumSet.allOf(EnumFacing.class);
        }

        public IGridHost getMachine() {
            return TileAECapAdapter.this;
        }

        public void gridChanged() {
        }

        public ItemStack getMachineRepresentation() {
            if (this.display == null) {
                this.display = new ItemStack(Item.func_150898_a((Block)TileAECapAdapter.this.field_145850_b.func_180495_p(TileAECapAdapter.this.field_174879_c).func_177230_c()));
            }
            return this.display;
        }
    }

    private class ProxyCapability
    implements IAEGridProxyCapability {
        private ProxyCapability() {
        }

        @Override
        public IGridNode getProxiedObject() {
            return TileAECapAdapter.this.node;
        }
    }
}

