/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.network;

import flaxbeard.cyberware.common.block.tile.TileEntityEngineeringTable;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class EngineeringDestroyPacket
implements IMessage {
    private BlockPos pos;
    private int dimensionId;

    public EngineeringDestroyPacket() {
    }

    public EngineeringDestroyPacket(BlockPos pos, int dimensionId) {
        this.pos = pos;
        this.dimensionId = dimensionId;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.dimensionId);
    }

    public void fromBytes(ByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.pos = new BlockPos(x, y, z);
        this.dimensionId = buf.readInt();
    }

    private static class DoSync
    implements Runnable {
        private BlockPos pos;
        private int dimensionId;

        private DoSync(BlockPos pos, int dimensionId) {
            this.pos = pos;
            this.dimensionId = dimensionId;
        }

        @Override
        public void run() {
            WorldServer world = DimensionManager.getWorld((int)this.dimensionId);
            TileEntity te = world.func_175625_s(this.pos);
            if (te instanceof TileEntityEngineeringTable) {
                TileEntityEngineeringTable engineering = (TileEntityEngineeringTable)te;
                engineering.smash(true);
            }
        }
    }

    public static class EngineeringDestroyPacketHandler
    implements IMessageHandler<EngineeringDestroyPacket, IMessage> {
        public IMessage onMessage(EngineeringDestroyPacket message, MessageContext ctx) {
            DimensionManager.getWorld((int)message.dimensionId).func_152344_a((Runnable)new DoSync(message.pos, message.dimensionId));
            return null;
        }
    }
}

