/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.item.EnableDisableHelper;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.IMenuItem;
import flaxbeard.cyberware.common.item.ItemCyberware;
import flaxbeard.cyberware.common.network.CyberwarePacketHandler;
import flaxbeard.cyberware.common.network.SwitchHeldItemAndRotationPacket;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ItemMuscleUpgrade
extends ItemCyberware
implements IMenuItem {
    private static final UUID speedId = UUID.fromString("f0ab4766-4be1-11e6-beb8-9e71128cae77");
    private static final UUID strengthId = UUID.fromString("f63d6916-4be1-11e6-beb8-9e71128cae77");
    private Set<UUID> lastBoostSpeed = new HashSet<UUID>();
    private Set<UUID> lastBoostStrength = new HashSet<UUID>();
    private static final float[] f = new float[]{1.0f, 0.0f, 0.0f};

    public ItemMuscleUpgrade(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void onAdded(EntityLivingBase entity, ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            HashMultimap multimap = HashMultimap.create();
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(speedId, "Muscle speed upgrade", 1.5, 0));
            entity.func_110140_aT().func_111147_b((Multimap)multimap);
        } else if (stack.func_77952_i() == 1) {
            HashMultimap multimap = HashMultimap.create();
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(strengthId, "Muscle damage upgrade", 3.0, 0));
            entity.func_110140_aT().func_111147_b((Multimap)multimap);
        }
    }

    @Override
    public void onRemoved(EntityLivingBase entity, ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            HashMultimap multimap = HashMultimap.create();
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(speedId, "Muscle speed upgrade", 1.5, 0));
            entity.func_110140_aT().func_111148_a((Multimap)multimap);
        } else if (stack.func_77952_i() == 1) {
            HashMultimap multimap = HashMultimap.create();
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(strengthId, "Muscle damage upgrade", 3.0, 0));
            entity.func_110140_aT().func_111148_a((Multimap)multimap);
        }
    }

    @Override
    public int installedStackSize(ItemStack stack) {
        return stack.func_77952_i() == 0 ? 3 : 1;
    }

    @SubscribeEvent
    public void handleHurt(LivingHurtEvent event) {
        EntityLivingBase e = event.getEntityLiving();
        if (e == null) {
            return;
        }
        ItemStack test = new ItemStack((Item)this, 1, 0);
        int rank = CyberwareAPI.getCyberwareRank((Entity)e, test);
        if (!event.isCanceled() && e instanceof EntityPlayer && rank > 1 && EnableDisableHelper.isEnabled(CyberwareAPI.getCyberware((Entity)e, test)) && this.lastBoostStrength.contains(e.func_110124_au())) {
            EntityPlayer p = (EntityPlayer)e;
            if (event.getSource() instanceof EntityDamageSource && !(event.getSource() instanceof EntityDamageSourceIndirect)) {
                EntityDamageSource source = (EntityDamageSource)event.getSource();
                Entity attacker = source.func_76346_g();
                int lastAttacked = (Integer)ReflectionHelper.getPrivateValue(CombatTracker.class, (Object)p.func_110142_aN(), (int)2);
                if (p.field_70173_aa - lastAttacked > 120) {
                    ItemStack weapon = p.func_184614_ca();
                    int loc = -1;
                    if (!weapon.func_190926_b() && (p.func_184605_cv() > 0 || weapon.func_77973_b() instanceof ItemSword || weapon.func_77973_b().getAttributeModifiers(EntityEquipmentSlot.MAINHAND, weapon).containsKey((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()))) {
                        loc = p.field_71071_by.field_70461_c;
                    }
                    if (loc == -1) {
                        double mostDamage = 0.0;
                        for (int i = 0; i < 10; ++i) {
                            double damage;
                            Multimap modifiers;
                            ItemStack potentialWeapon;
                            if (i == p.field_71071_by.field_70461_c || (potentialWeapon = (ItemStack)p.field_71071_by.field_70462_a.get(i)).func_190926_b() || !(modifiers = potentialWeapon.func_77973_b().getAttributeModifiers(EntityEquipmentSlot.MAINHAND, potentialWeapon)).containsKey((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()) || !((damage = ((AttributeModifier)modifiers.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a()).iterator().next()).func_111164_d()) > mostDamage) && loc != -1) continue;
                            mostDamage = damage;
                            loc = i;
                        }
                    }
                    if (loc != -1) {
                        p.field_71071_by.field_70461_c = loc;
                        CyberwarePacketHandler.INSTANCE.sendTo((IMessage)new SwitchHeldItemAndRotationPacket(loc, p.func_145782_y(), rank > 2 ? attacker.func_145782_y() : -1), (EntityPlayerMP)p);
                        WorldServer world = (WorldServer)p.field_70170_p;
                        for (EntityPlayer trackingPlayer : world.func_73039_n().getTrackingPlayers((Entity)p)) {
                            CyberwarePacketHandler.INSTANCE.sendTo((IMessage)new SwitchHeldItemAndRotationPacket(loc, p.func_145782_y(), rank > 2 ? attacker.func_145782_y() : -1), (EntityPlayerMP)trackingPlayer);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void handleLivingUpdate(CyberwareUpdateEvent event) {
        boolean powerUsed;
        EntityLivingBase e = event.getEntityLiving();
        if (e == null) {
            return;
        }
        ItemStack test = new ItemStack((Item)this, 1, 1);
        if (CyberwareAPI.isCyberwareInstalled((Entity)e, test)) {
            boolean bl = powerUsed = e.field_70173_aa % 20 == 0 ? CyberwareAPI.getCapability((Entity)e).usePower(test, this.getPowerConsumption(test)) : this.lastBoostStrength.contains(e.func_110124_au());
            if (powerUsed) {
                if (!e.func_70090_H() && e.field_70122_E && e.field_191988_bg > 0.0f) {
                    e.func_191958_b(0.0f, 0.0f, 0.5f, 0.075f);
                }
                this.onAdded(e, test);
            } else {
                this.onRemoved(e, test);
            }
            if (powerUsed) {
                this.lastBoostStrength.add(e.func_110124_au());
            } else {
                this.lastBoostStrength.remove(e.func_110124_au());
            }
        } else {
            this.onRemoved(e, test);
            this.lastBoostStrength.remove(e.func_110124_au());
        }
        test = new ItemStack((Item)this, 1, 0);
        if (CyberwareAPI.isCyberwareInstalled((Entity)e, test) && EnableDisableHelper.isEnabled(CyberwareAPI.getCyberware((Entity)e, test))) {
            boolean bl = powerUsed = e.field_70173_aa % 20 == 0 ? CyberwareAPI.getCapability((Entity)e).usePower(test, this.getPowerConsumption(test)) : this.lastBoostSpeed.contains(e.func_110124_au());
            if (powerUsed) {
                this.onAdded(e, test);
            } else {
                this.onRemoved(e, test);
            }
            if (powerUsed) {
                this.lastBoostSpeed.add(e.func_110124_au());
            } else {
                this.lastBoostSpeed.remove(e.func_110124_au());
            }
        } else {
            this.onRemoved(e, test);
            this.lastBoostSpeed.remove(e.func_110124_au());
        }
    }

    @Override
    public int getPowerConsumption(ItemStack stack) {
        return stack.func_77952_i() == 0 ? 2 : 3;
    }

    @Override
    protected int getUnmodifiedEssenceCost(ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            switch (stack.func_190916_E()) {
                case 1: {
                    return 9;
                }
                case 2: {
                    return 10;
                }
                case 3: {
                    return 11;
                }
            }
        }
        return super.getUnmodifiedEssenceCost(stack);
    }

    @Override
    public boolean hasMenu(ItemStack stack) {
        return stack.func_77952_i() == 0;
    }

    @Override
    public void use(Entity e, ItemStack stack) {
        EnableDisableHelper.toggle(stack);
    }

    @Override
    public String getUnlocalizedLabel(ItemStack stack) {
        return EnableDisableHelper.getUnlocalizedLabel(stack);
    }

    @Override
    public float[] getColor(ItemStack stack) {
        return (float[])(EnableDisableHelper.isEnabled(stack) ? f : null);
    }

    @Override
    public boolean isEssential(ItemStack stack) {
        return stack.func_77952_i() == 1;
    }

    @Override
    public boolean isIncompatible(ItemStack stack, ItemStack other) {
        return stack.func_77952_i() == 1 && CyberwareAPI.getCyberware(other).isEssential(other);
    }
}

