/*
 * Decompiled with CFR 0.152.
 */
package com.dmonsters.entity;

import com.dmonsters.ai.EntityAIStranger;
import com.dmonsters.main.ModConfig;
import com.dmonsters.main.ModSounds;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityStranger
extends EntityMob {
    private static final DataParameter<Boolean> ARMS_RAISED = EntityDataManager.func_187226_a(EntityStranger.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityStranger.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final ResourceLocation LOOT = new ResourceLocation("dmonsters", "stranger");

    public EntityStranger(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.5f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15 * (double)ModConfig.speedMultiplier * (double)ModConfig.entrailSpeedMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0 * (double)ModConfig.strengthMultiplier * (double)ModConfig.entrailStrengthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0 * (double)ModConfig.healthMultiplier * (double)ModConfig.entrailHealthMultiplier);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIStranger(this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.applyEntityAI();
    }

    private void applyEntityAI() {
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            this.func_184185_a(ModSounds.STRANGER_ATTACK, 1.0f, 1.0f);
            if (entityIn instanceof EntityPlayer) {
                this.hitPlayer(entityIn);
                entityIn.func_70097_a(DamageSource.field_76377_j, 10.0f);
            }
            return true;
        }
        return false;
    }

    public void func_70636_d() {
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K) {
            BlockPos blockpos;
            float f = this.func_70013_c();
            BlockPos blockPos = blockpos = this.func_184187_bx() instanceof EntityBoat ? new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v).func_177984_a() : new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v);
            if (f > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(blockpos)) {
                this.func_70015_d(8);
            }
        }
        super.func_70636_d();
    }

    private void hitPlayer(Entity entityIn) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.func_184185_a(ModSounds.STRANGER_IMPACT, 1.0f, 1.0f);
        Random rnd = new Random();
        float rndNum = rnd.nextFloat() + 0.1f;
        entityIn.func_70024_g(0.0, (double)rndNum, 0.0);
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.STRANGER_DEATH;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.STRANGER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource dmgSource) {
        return ModSounds.STRANGER_HURT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }
}

