/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens.handler;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.setycz.chickens.ChickensMod;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class ItemHolder {
    private String source = null;
    private String itemID;
    private int metaID;
    private NBTTagCompound nbtData;
    private JsonObject nbtRawJson;
    private boolean isComplete = false;
    private ItemStack stack = ItemStack.field_190927_a;
    private int stackSize = 1;
    public static HashMap<String, Integer> ErroredItems = new HashMap();
    Gson gson = new Gson();

    public ItemHolder() {
        this.itemID = Items.field_190931_a.getRegistryName().toString();
        this.metaID = 0;
        this.nbtData = null;
        this.stack = ItemStack.field_190927_a;
    }

    public ItemHolder(Item itemIn) {
        this.itemID = itemIn.getRegistryName().toString();
        this.metaID = 0;
        this.nbtData = null;
        this.stack = ItemStack.field_190927_a;
    }

    public ItemHolder(ItemStack stackIn, boolean isFinal) {
        this.itemID = stackIn.func_77973_b().getRegistryName().toString();
        this.metaID = stackIn.func_77960_j();
        this.stack = stackIn;
        this.nbtData = stackIn.func_77942_o() ? stackIn.func_77978_p() : null;
        this.stackSize = stackIn.func_190916_E();
        this.isComplete = isFinal;
    }

    public ItemHolder(String itemID, int metaID, int qty) {
        this.itemID = itemID;
        this.metaID = metaID;
        this.nbtData = null;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public String getSource() {
        return this.source;
    }

    public ItemHolder setSource(String sourceIn) {
        this.source = sourceIn;
        return this;
    }

    @Nullable
    public Item getItem() {
        return Item.func_111206_d((String)this.itemID);
    }

    public int getStackSize() {
        return !this.stack.func_190926_b() ? this.stack.func_190916_E() : this.stackSize;
    }

    public int getMeta() {
        return this.metaID;
    }

    public int getAmount() {
        return this.stackSize;
    }

    public ItemStack getStack() {
        if (ErroredItems.containsKey(this.itemID)) {
            this.handleItemNotFound();
        }
        if (!this.isComplete) {
            this.isComplete = true;
            Item item = this.getItem();
            if (item != null) {
                this.stack = new ItemStack(this.getItem(), this.getAmount(), this.metaID);
                if (this.nbtData != null && !this.nbtData.func_82582_d()) {
                    this.stack.func_77982_d(this.nbtData);
                }
            } else {
                this.handleItemNotFound();
            }
        }
        return this.stack.func_77946_l();
    }

    private void handleItemNotFound() {
        if (!ErroredItems.containsKey(this.itemID)) {
            ErroredItems.put(this.itemID, 1);
        } else {
            ErroredItems.replace(this.itemID, ErroredItems.get(this.itemID) + 1);
        }
        if (ErroredItems.get(this.itemID) <= 3) {
            ChickensMod.log.error("Could not find specfied Item: [" + this.itemID + "]" + (this.hasSource() ? " | Source: [" + this.getSource() + "]" : "") + " | Dropping Default Item: [" + this.stack.func_82833_r() + "]");
            if (ErroredItems.get(this.itemID) == 3) {
                ChickensMod.log.error("Will silent error this itemID: [" + this.itemID + "]");
            }
        }
    }

    public ItemHolder readJsonObject(JsonObject data) throws NumberFormatException {
        this.itemID = data.has("itemID") ? data.get("itemID").getAsString() : Items.field_190931_a.getRegistryName().toString();
        this.metaID = data.has("metaID") ? data.get("metaID").getAsInt() : 0;
        this.stackSize = data.has("qty") ? data.get("qty").getAsInt() : 1;
        this.nbtRawJson = data.has("nbt") ? data.get("nbt").getAsJsonObject() : null;
        try {
            this.nbtData = data.has("nbt") ? JsonToNBT.func_180713_a((String)data.get("nbt").getAsJsonObject().toString()) : null;
        }
        catch (NBTException e) {
            e.printStackTrace();
            this.nbtData = null;
        }
        return this;
    }

    public JsonObject writeJsonObject(JsonObject data) throws NumberFormatException {
        data.addProperty("itemID", this.itemID);
        data.addProperty("metaID", (Number)this.metaID);
        if (this.stackSize > 1) {
            data.addProperty("qty", (Number)this.getStackSize());
        }
        if (this.nbtData != null && !this.nbtData.func_82582_d()) {
            JsonElement element = (JsonElement)this.gson.fromJson(this.nbtData.toString(), JsonElement.class);
            data.add("nbt", (JsonElement)element.getAsJsonObject());
        }
        return data;
    }

    public String toString() {
        return this.itemID + ":" + this.metaID + ":" + this.stackSize + (this.nbtData != null ? ":" + this.nbtData.toString() : "");
    }
}

