/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.util;

import java.lang.reflect.Constructor;
import net.minecraft.command.EntityNotFoundException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class EntityUtil {
    public static String getEntityName(String entityId) {
        Pair<String, String> nameAndNbt = EntityUtil.splitNameAndNBT(entityId);
        return EntityList.func_191302_a((ResourceLocation)new ResourceLocation((String)nameAndNbt.getLeft()));
    }

    public static EntityCreator loadEntity(String entityId) {
        Pair<String, String> nameAndNbt = EntityUtil.splitNameAndNBT(entityId);
        entityId = (String)nameAndNbt.getLeft();
        String nbtStr = (String)nameAndNbt.getRight();
        NBTTagCompound nbt = null;
        if (!nbtStr.isEmpty()) {
            try {
                nbt = JsonToNBT.func_180713_a((String)nbtStr);
            }
            catch (NBTException e) {
                e.printStackTrace();
            }
        }
        Class clazz = ((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityId))).getEntityClass();
        NBTTagCompound useNbt = nbt;
        String useId = entityId;
        try {
            Constructor constructor = clazz.getConstructor(World.class);
            return world -> {
                try {
                    Entity entity = (Entity)constructor.newInstance(world);
                    if (useNbt != null) {
                        entity.func_70020_e(useNbt);
                    }
                    return entity;
                }
                catch (Exception e) {
                    throw new EntityNotFoundException("Can't load entity " + useId);
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find constructor for entity type " + entityId, e);
        }
    }

    private static Pair<String, String> splitNameAndNBT(String entityId) {
        int nbtStart = entityId.indexOf("{");
        String nbtStr = "";
        if (nbtStart > 0) {
            nbtStr = entityId.substring(nbtStart).replaceAll("([^\\\\])'", "$1\"").replaceAll("\\\\'", "'");
            entityId = entityId.substring(0, nbtStart);
        }
        return Pair.of((Object)entityId, (Object)nbtStr);
    }

    public static interface EntityCreator {
        public Entity create(World var1) throws EntityNotFoundException;
    }
}

