/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.togetherforever.action.recovery;

import codersafterdark.reskillable.api.ReskillableRegistries;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.PlayerSkillInfo;
import codersafterdark.reskillable.api.requirement.RequirementCache;
import codersafterdark.reskillable.api.requirement.SkillRequirement;
import codersafterdark.reskillable.api.skill.Skill;
import codersafterdark.reskillable.api.toast.ToastHelper;
import com.buuz135.togetherforever.action.recovery.AbstractOfflineRecovery;
import com.buuz135.togetherforever.api.IPlayerInformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class ReskillableLevelUpOfflineRecovery
extends AbstractOfflineRecovery {
    @Override
    public void recoverMissingPlayer(IPlayerInformation playerInformation) {
        PlayerData data = PlayerDataHandler.get((EntityPlayer)playerInformation.getPlayer());
        if (data == null) {
            return;
        }
        HashMap<Skill, Integer> levelUps = new HashMap<Skill, Integer>();
        ArrayList<Map.Entry> removeList = new ArrayList<Map.Entry>();
        for (Map.Entry entry : new ArrayList(this.offlineRecoveries.entries())) {
            if (!((IPlayerInformation)entry.getKey()).getUUID().equals(playerInformation.getUUID())) continue;
            NBTTagCompound value = (NBTTagCompound)entry.getValue();
            String skillID = value.func_74779_i("Skill");
            Skill skill2 = (Skill)ReskillableRegistries.SKILLS.getValue(new ResourceLocation(skillID));
            if (skill2 != null) {
                PlayerSkillInfo skillInfo = data.getSkillInfo(skill2);
                int newLevel = value.func_74762_e("NewLevel");
                if (newLevel == 0) {
                    skillInfo.levelUp();
                    levelUps.put(skill2, skillInfo.getLevel());
                } else if (skillInfo.getLevel() < newLevel) {
                    skillInfo.setLevel(newLevel);
                    levelUps.put(skill2, newLevel);
                }
            }
            removeList.add(entry);
        }
        for (Map.Entry entry : removeList) {
            this.offlineRecoveries.remove(entry.getKey(), entry.getValue());
        }
        if (!levelUps.isEmpty()) {
            data.saveAndSync();
            RequirementCache.invalidateCache((UUID)playerInformation.getUUID(), (Class[])new Class[]{SkillRequirement.class});
            levelUps.forEach((skill, integer) -> ToastHelper.sendSkillToast((EntityPlayerMP)playerInformation.getPlayer(), (Skill)skill, (int)integer));
        }
    }
}

