/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer;

import com.bloodnbonesgaming.dimensionalcontrol.config.biomeprovider.BiomeProviderDefinitionCustomLight;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.BiomeEdgeData;
import java.util.List;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerShoreDC
extends GenLayer {
    final List<BiomeEdgeData> shoreDataList;

    public GenLayerShoreDC(long seed, GenLayer parent, BiomeProviderDefinitionCustomLight definition) {
        super(seed);
        this.field_75909_a = parent;
        this.shoreDataList = definition.getBiomeShores();
    }

    public int[] func_75904_a(int chunkX, int chunkZ, int width, int depth) {
        int[] parentInts = this.field_75909_a.func_75904_a(chunkX - 1, chunkZ - 1, width + 2, depth + 2);
        int[] returnInts = IntCache.func_76445_a((int)(width * depth));
        for (int z = 0; z < depth; ++z) {
            for (int x = 0; x < width; ++x) {
                this.func_75903_a(x + chunkX, z + chunkZ);
                int primary = parentInts[x + 1 + (z + 1) * (width + 2)];
                boolean foundShore = false;
                if (this.shoreDataList != null) {
                    for (BiomeEdgeData data : this.shoreDataList) {
                        if (!data.usedForBiome(primary)) continue;
                        int biome1 = parentInts[x + 1 + (z + 1 - 1) * (width + 2)];
                        int biome2 = parentInts[x + 1 + 1 + (z + 1) * (width + 2)];
                        int biome3 = parentInts[x + 1 - 1 + (z + 1) * (width + 2)];
                        int biome4 = parentInts[x + 1 + (z + 1 + 1) * (width + 2)];
                        if (data.useEdge(biome1)) {
                            returnInts[x + z * width] = data.getEdge();
                            foundShore = true;
                            break;
                        }
                        if (data.useEdge(biome2)) {
                            returnInts[x + z * width] = data.getEdge();
                            foundShore = true;
                            break;
                        }
                        if (data.useEdge(biome3)) {
                            returnInts[x + z * width] = data.getEdge();
                            foundShore = true;
                            break;
                        }
                        if (!data.useEdge(biome4)) continue;
                        returnInts[x + z * width] = data.getEdge();
                        foundShore = true;
                        break;
                    }
                }
                if (foundShore) continue;
                returnInts[x + z * width] = primary;
            }
        }
        return returnInts;
    }
}

