/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer;

import com.bloodnbonesgaming.dimensionalcontrol.DimensionalControl;
import com.bloodnbonesgaming.dimensionalcontrol.config.biomeprovider.BiomeProviderDefinitionCustomLight;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.EnumOceanSize;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/genlayers/GenLayerRemoveTooMuchOceanDC", classExplaination="A configurable version of the vanilla GenLayerRemoveTooMuchOcean. Removes \"excess\" ocean biomes.")
public class GenLayerRemoveTooMuchOceanDC
extends GenLayer {
    private EnumOceanSize size;

    @ScriptMethodDocumentation(args="long, GenLayer", usage="base layer seed, parent layer", notes="Constructs the layer with its base seed and parent layer.")
    public GenLayerRemoveTooMuchOceanDC(long seed, GenLayer parent) {
        super(seed);
        this.field_75909_a = parent;
    }

    public GenLayerRemoveTooMuchOceanDC(long seed, GenLayer parent, BiomeProviderDefinitionCustomLight definition) {
        this(seed, parent);
        this.size = definition.getOceanSize();
    }

    @ScriptMethodDocumentation(args="String", usage="ocean size", notes="Sets the ocean size for the layer. Options are \"Small\", \"Large\", \"Default\". Small replaces all ocean with plains, large does nothing, default does vanilla removal behavior.")
    public void setOceanSize(String oceanSize) {
        EnumOceanSize size = EnumOceanSize.valueOf(oceanSize.toUpperCase());
        if (size != null) {
            this.size = size;
        } else {
            DimensionalControl.instance.getLog().error((Object)(oceanSize + " is not a valid ocean size."));
        }
    }

    public int[] func_75904_a(int chunkX, int chunkZ, int width, int depth) {
        int i1 = chunkX - 1;
        int j1 = chunkZ - 1;
        int k1 = width + 2;
        int l1 = depth + 2;
        int[] aint = this.field_75909_a.func_75904_a(i1, j1, k1, l1);
        int[] aint1 = IntCache.func_76445_a((int)(width * depth));
        for (int z = 0; z < depth; ++z) {
            block5: for (int x = 0; x < width; ++x) {
                int currentBiome = aint[x + 1 + (z + 1) * k1];
                switch (this.size) {
                    case SMALL: {
                        aint1[x + z * width] = 1;
                        continue block5;
                    }
                    case LARGE: {
                        aint1[x + z * width] = currentBiome;
                        continue block5;
                    }
                    default: {
                        int biome1 = aint[x + 1 + (z + 1 - 1) * (width + 2)];
                        int biome2 = aint[x + 1 + 1 + (z + 1) * (width + 2)];
                        int biome3 = aint[x + 1 - 1 + (z + 1) * (width + 2)];
                        int biome4 = aint[x + 1 + (z + 1 + 1) * (width + 2)];
                        this.func_75903_a(x + chunkX, z + chunkZ);
                        if (currentBiome == 0 && biome1 == 0 && biome2 == 0 && biome3 == 0 && biome4 == 0 && this.func_75902_a(2) == 0) {
                            aint1[x + z * width] = 1;
                            continue block5;
                        }
                        aint1[x + z * width] = currentBiome;
                        continue block5;
                    }
                }
            }
        }
        return aint1;
    }
}

