/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer;

import com.bloodnbonesgaming.dimensionalcontrol.config.biomeprovider.BiomeProviderDefinitionCustomLight;
import com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer.HillData;
import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/genlayers/GenLayerHillsDC", classExplaination="A configurable version of the vanilla GenLayerHills. Pseudo-randomly adds hill and mutated biomes to existing biomes.")
public class GenLayerHillsDC
extends GenLayer {
    private final GenLayer secondParent;
    private HillData hillData;

    @ScriptMethodDocumentation(args="long, GenLayer, GenLayer", usage="layer base seed, first parent, second parent", notes="Constructs the layer with its seed and parent layers. The first layer is the normal biome map, and the second is the hill/river initialization layer.")
    public GenLayerHillsDC(long seed, GenLayer parent, GenLayer secondParent) {
        super(seed);
        this.field_75909_a = parent;
        this.secondParent = secondParent;
    }

    public GenLayerHillsDC(long seed, GenLayer parent, GenLayer secondParent, BiomeProviderDefinitionCustomLight definition) {
        this(seed, parent, secondParent);
        this.hillData = definition.getHillData();
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID, ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome ID, mutation biome ID", notes="Sets the mutation biome for the provided biomeID.")
    public void setMutation(int biome, int mutation) {
        if (this.hillData == null) {
            this.hillData = new HillData();
        }
        this.hillData.setMutation(biome, mutation);
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID, ArgType.NON_NULL_BIOME_ID_ARRAY})
    @ScriptMethodDocumentation(usage="biome ID, hill biome ID array", notes="Sets the hill biomes for the provided biomeID.")
    public void setHill(int biome, int[] hills) {
        if (this.hillData == null) {
            this.hillData = new HillData();
        }
        this.hillData.setHill(biome, hills);
    }

    @ScriptMethodDocumentation(usage="", notes="Adds all of the hill biomes that would be added by the default GenLayerHills layer.")
    public void addDefaultHills() {
        if (this.hillData == null) {
            this.hillData = new HillData();
        }
        this.hillData.addDefaultHills();
    }

    @ScriptMethodDocumentation(usage="", notes="Adds all of the mutation biomes that would be added by the default GenLayerHills layer.")
    public void addDefaultMutations() {
        if (this.hillData == null) {
            this.hillData = new HillData();
        }
        this.hillData.addDefaultMutations();
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome ID", notes="Removes the hill biomes for the provided biome.")
    public void removeHill(int biome) {
        if (this.hillData == null) {
            this.hillData = new HillData();
        }
        this.hillData.removeHill(biome);
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="", notes="Removes the mutation biome for the provided biome.")
    public void removeMutation(int biome) {
        if (this.hillData == null) {
            this.hillData = new HillData();
        }
        this.hillData.removeMutation(biome);
    }

    public int[] func_75904_a(int chunkX, int chunkZ, int width, int depth) {
        int[] parentInts = this.field_75909_a.func_75904_a(chunkX - 1, chunkZ - 1, width + 2, depth + 2);
        int[] secondParentInts = this.secondParent.func_75904_a(chunkX - 1, chunkZ - 1, width + 2, depth + 2);
        int[] returnInts = IntCache.func_76445_a((int)(width * depth));
        boolean nullData = this.hillData == null;
        for (int z = 0; z < depth; ++z) {
            for (int x = 0; x < width; ++x) {
                boolean useMutation;
                this.func_75903_a(x + chunkX, z + chunkZ);
                int parentIndex = x + 1 + (z + 1) * (width + 2);
                int currentBiome = parentInts[parentIndex];
                int riverInt = secondParentInts[parentIndex];
                boolean useMutatedHill = (riverInt - 2) % 29 == 0;
                boolean bl = useMutation = currentBiome != 0 && riverInt >= 2 && (riverInt - 2) % 29 == 1;
                if (!nullData) {
                    if (useMutation) {
                        Integer mutation = this.hillData.getMutation(currentBiome);
                        returnInts[x + z * width] = mutation != null ? mutation : currentBiome;
                        continue;
                    }
                    if (this.func_75902_a(3) != 0 && !useMutatedHill) {
                        returnInts[x + z * width] = currentBiome;
                        continue;
                    }
                    int hill = -1;
                    int[] hills = this.hillData.getHills(currentBiome);
                    if (hills != null) {
                        hill = hills.length > 2 ? (this.func_75902_a(3) == 0 ? (this.func_75902_a(2) == 0 ? hills[1] : hills[0]) : hills[2]) : (hills.length == 2 ? (this.func_75902_a(3) == 0 ? hills[0] : hills[1]) : hills[0]);
                    }
                    if (hill != -1) {
                        if (useMutatedHill) {
                            Integer mutation = this.hillData.getMutation(hill);
                            int n = hill = mutation != null ? mutation : -1;
                        }
                        if (hill != -1) {
                            int biome1 = parentInts[x + 1 + z * (width + 2)];
                            int biome2 = parentInts[x + 2 + (z + 1) * (width + 2)];
                            int biome3 = parentInts[x + (z + 1) * (width + 2)];
                            int biome4 = parentInts[x + 1 + (z + 2) * (width + 2)];
                            int count = 0;
                            if (GenLayerHillsDC.func_151616_a((int)biome1, (int)currentBiome)) {
                                ++count;
                            }
                            if (GenLayerHillsDC.func_151616_a((int)biome2, (int)currentBiome)) {
                                ++count;
                            }
                            if (GenLayerHillsDC.func_151616_a((int)biome3, (int)currentBiome)) {
                                ++count;
                            }
                            if (GenLayerHillsDC.func_151616_a((int)biome4, (int)currentBiome)) {
                                ++count;
                            }
                            if (count >= 3) {
                                returnInts[x + z * width] = hill;
                                continue;
                            }
                            returnInts[x + z * width] = currentBiome;
                            continue;
                        }
                        returnInts[x + z * width] = currentBiome;
                        continue;
                    }
                    returnInts[x + z * width] = currentBiome;
                    continue;
                }
                returnInts[x + z * width] = currentBiome;
            }
        }
        return returnInts;
    }
}

