/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.world.mapgen.layer;

import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerCombine
extends GenLayer {
    private final GenLayer parent2;
    private List<int[]> combinations = new ArrayList<int[]>();

    @ScriptArgs(args={ArgType.LONG, ArgType.GENLAYER, ArgType.GENLAYER, ArgType.NON_NULL_BIOME_ID_ARRAY})
    @ScriptMethodDocumentation(usage="base layer seed, first parent layer, second parent layer, whitelist", notes="Constructs the layer with its seed, parent layers and whitelist.")
    public GenLayerCombine(long seed, GenLayer parent, GenLayer parent2) {
        super(seed);
        this.field_75909_a = parent;
        this.parent2 = parent2;
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID_ARRAY})
    public void addCombination(int[] combination) {
        this.combinations.add(combination);
    }

    public int[] func_75904_a(int chunkX, int chunkZ, int width, int depth) {
        int[] parentInts = this.field_75909_a.func_75904_a(chunkX - 1, chunkZ - 1, width + 2, depth + 2);
        int[] parentInts2 = this.parent2.func_75904_a(chunkX - 1, chunkZ - 1, width + 2, depth + 2);
        int[] returnInts = IntCache.func_76445_a((int)(width * depth));
        for (int z = 0; z < depth; ++z) {
            for (int x = 0; x < width; ++x) {
                this.func_75903_a(x + chunkX, z + chunkZ);
                int parentIndex = x + 1 + (z + 1) * (width + 2);
                int currentBiome = parentInts[parentIndex];
                int currentBiome2 = parentInts2[parentIndex];
                boolean combined = false;
                for (int[] combination : this.combinations) {
                    if (combination[0] != currentBiome || combination[1] != currentBiome2) continue;
                    returnInts[x + z * width] = combination[2];
                    combined = true;
                    break;
                }
                if (combined) continue;
                returnInts[x + z * width] = currentBiome;
            }
        }
        return returnInts;
    }
}

