/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.world.chunkgenerator;

import com.bloodnbonesgaming.dimensionalcontrol.util.MathHelper;
import com.bloodnbonesgaming.dimensionalcontrol.util.noise.VoronoiNoiseGenerator;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;

public class ChunkGeneratorWorleyCave
implements IChunkGenerator {
    final Random rand = new Random();
    final Random pointNoise = new Random();
    final World world;
    final VoronoiNoiseGenerator noiseGen = new VoronoiNoiseGenerator();
    double[] smallNoiseArray = new double[825];
    double[] largeNoiseArray = new double[65536];

    public ChunkGeneratorWorleyCave(World world) {
        this.world = world;
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        this.generateWorleyCaves3D(x, z, chunkPrimer);
        Chunk chunk = new Chunk(this.world, chunkPrimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)Biomes.field_185440_P);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void generate2DWorleyCaves(int chunkX, int chunkZ, ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double noise = this.noiseGen.eval(16, chunkX * 16 + x, chunkZ * 16 + z);
                if (!(noise > 0.3)) continue;
                for (int y = 0; y < 64; ++y) {
                    primer.func_177855_a(x, y, z, Blocks.field_150348_b.func_176223_P());
                }
            }
        }
    }

    private void generate2DWorleyTerrain(int chunkX, int chunkZ, ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double noise = this.noiseGen.eval(16, chunkX * 16 + x, chunkZ * 16 + z);
                int y = 0;
                while ((double)y < noise * 96.0) {
                    primer.func_177855_a(x, y, z, Blocks.field_150348_b.func_176223_P());
                    ++y;
                }
            }
        }
    }

    private void generateDistances(List<BlockPos> points, List<Double> distances, int x, int z) {
        for (BlockPos pos : points) {
            distances.add(this.getDistance(pos, x, 0, z));
        }
        Collections.sort(distances);
    }

    private void generatePoints(List<BlockPos> points, int chunkX, int chunkZ) {
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                this.pointNoise.setSeed((long)(x + chunkX) * 341873128712L + (long)(z + chunkZ) * 132897987541L);
                for (int i = 0; i < 3; ++i) {
                    points.add(new BlockPos((x + chunkX) * 16 + this.pointNoise.nextInt(16), 0, (z + chunkZ) * 16 + this.pointNoise.nextInt(16)));
                }
            }
        }
    }

    private void fillChunks(int chunkX, int chunkZ, ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 256; ++y) {
                    primer.func_177855_a(x, y, z, Blocks.field_150348_b.func_176223_P());
                }
            }
        }
    }

    private void generateNoise(double[] array, int arraySizeX, int arraySizeY, int arraySizeZ, int x, int y, int z, int xCoordinateScale, int yCoordinateScale, int zCoordinateScale) {
        for (int xI = 0; xI < arraySizeX; ++xI) {
            for (int zI = 0; zI < arraySizeZ; ++zI) {
                for (int yI = 0; yI < arraySizeY; ++yI) {
                    double worley;
                    int index = (xI * arraySizeX + zI) * arraySizeY + yI;
                    array[index] = worley = this.noiseGen.octaves(1, 64, x + xI * xCoordinateScale, y + yI * yCoordinateScale, z + zI * zCoordinateScale);
                }
            }
        }
    }

    private void generateWorleyCaves3D(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.generateNoise(this.smallNoiseArray, 5, 33, 5, chunkX * 16, 0, chunkZ * 16, 4, 8, 4);
        MathHelper.interpolate(this.smallNoiseArray, this.largeNoiseArray, 5, 33, 5, 4, 8, 4);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y1 = 0; y1 < 16; ++y1) {
                    for (int y2 = 0; y2 < 16; ++y2) {
                        int y = y1 * 16 + y2;
                        double noise = this.largeNoiseArray[(x * 16 + z) * 256 + y];
                        if (!(noise > 18.0)) continue;
                        primer.func_177855_a(x, y, z, Blocks.field_150348_b.func_176223_P());
                    }
                }
            }
        }
    }

    private void generateWorleyCaves(int chunkX, int chunkZ, ChunkPrimer primer) {
    }

    private void generateDistanceList(List<Double> distances, List<BlockPos> points, int x, int y, int z) {
        for (BlockPos pos : points) {
            distances.add(this.getDistance(pos, x, y, z));
        }
        Collections.sort(distances);
    }

    private double getDistance(BlockPos pos, int x, int y, int z) {
        double d0 = Math.pow(Math.abs((double)(pos.func_177958_n() - x)), 2.0);
        double d1 = Math.pow(Math.abs((double)(pos.func_177956_o() - y)), 2.0);
        double d2 = Math.pow(Math.abs((double)(pos.func_177952_p() - z)), 2.0);
        return Math.sqrt(d0 + d1 + d2);
    }

    private void generatePoints(List<BlockPos> points, int x, int y, int z) {
        this.pointNoise.setSeed((long)x * 341873128712L + (long)z * 132897987541L + (long)y * 25500L);
        for (int i = 0; i < 3; ++i) {
            points.add(new BlockPos(x * 16 + this.pointNoise.nextInt(16), y * 16 + this.pointNoise.nextInt(16), z * 16 + this.pointNoise.nextInt(16)));
        }
    }

    public void func_185931_b(int x, int z) {
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return null;
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

