/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.world.chunkgenerator;

import com.bloodnbonesgaming.dimensionalcontrol.config.chunkprovider.ChunkGeneratorDefinitionSkyIslands;
import com.bloodnbonesgaming.dimensionalcontrol.util.noise.OpenSimplexNoiseGeneratorOctaves;
import com.bloodnbonesgaming.dimensionalcontrol.world.chunkgenerator.ChunkGeneratorVoid;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkGeneratorSkyIdealistic
extends ChunkGeneratorVoid {
    protected final OpenSimplexNoiseGeneratorOctaves islandNoiseGen;
    protected double[] depthBuffer;
    protected NoiseGeneratorPerlin surfaceNoise;
    protected final Random regionRand;
    protected IBlockState mainBlock;
    protected int regionSize;
    protected int maxIslandRadius;
    protected int maxIslandHeight;
    protected int minIslandHeight;
    protected double minBlockValue;
    protected double xStretch;
    protected double zStretch;
    protected double yBottomStretch;
    protected double noiseSizeX;
    protected double noiseSizeY;
    protected double noiseSizeZ;
    protected int noiseOctaves;
    protected double noisePersistence;
    protected boolean generateBiomeBlocks;
    protected boolean decorateBiomes;
    protected boolean populateAnimals;
    protected boolean populateIce;
    protected boolean populateLakes;
    protected boolean populateLavaLakes;
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
    protected static final IBlockState RED_SANDSTONE = Blocks.field_180395_cM.func_176223_P();
    protected static final IBlockState SANDSTONE = Blocks.field_150322_A.func_176223_P();
    protected static final IBlockState ICE = Blocks.field_150432_aD.func_176223_P();
    protected static final IBlockState WATER = Blocks.field_150355_j.func_176223_P();

    public ChunkGeneratorSkyIdealistic(ChunkGeneratorDefinitionSkyIslands definition, World worldIn, long seed, String p_i46668_5_) {
        super(worldIn, seed, p_i46668_5_);
        this.islandNoiseGen = new OpenSimplexNoiseGeneratorOctaves(this.worldObj.func_72905_C());
        this.depthBuffer = new double[256];
        this.surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
        this.regionRand = new Random();
        this.regionSize = 512;
        this.maxIslandRadius = 100;
        this.maxIslandHeight = 236;
        this.minIslandHeight = 0;
        this.minBlockValue = 0.3;
        this.xStretch = 1.0;
        this.zStretch = 1.0;
        this.yBottomStretch = 2.0;
        this.noiseSizeX = 128.0;
        this.noiseSizeY = 192.0;
        this.noiseSizeZ = 128.0;
        this.noiseOctaves = 6;
        this.noisePersistence = 0.45;
        this.generateBiomeBlocks = true;
        this.decorateBiomes = true;
        this.populateAnimals = true;
        this.populateIce = true;
        this.populateLakes = true;
        this.populateLavaLakes = true;
        this.mainBlock = definition.getMainBlock();
        if (this.mainBlock == null || this.mainBlock == Blocks.field_150350_a.func_176223_P()) {
            this.mainBlock = Blocks.field_150348_b.func_176223_P();
        }
        this.regionSize = definition.getRegionSize();
        this.maxIslandRadius = definition.getMaxIslandRadius();
        this.minIslandHeight = definition.getMinIslandHeight();
        this.maxIslandHeight = definition.getMaxIslandHeight();
        this.minBlockValue = definition.getMinBlockValue();
        this.xStretch = definition.getxStretch();
        this.yBottomStretch = definition.getyBottomStretch();
        this.zStretch = definition.getzStretch();
        this.noiseSizeX = definition.getNoiseSizeX();
        this.noiseSizeY = definition.getNoiseSizeY();
        this.noiseSizeZ = definition.getNoiseSizeZ();
        this.noiseOctaves = definition.getNoiseOctaves();
        this.noisePersistence = definition.getNoisePersistence();
        this.generateBiomeBlocks = definition.isGenerateBiomeBlocks();
        this.decorateBiomes = definition.isDecorateBiomes();
        this.populateAnimals = definition.isPopulateAnimals();
        this.populateIce = definition.isPopulateIce();
        this.populateLakes = definition.isPopulateLakes();
        this.populateLavaLakes = definition.isPopulateLavaLakes();
    }

    @Override
    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.generateTerrain(x, z, chunkprimer);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        if (ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)x, (int)z, (ChunkPrimer)chunkprimer, (World)this.worldObj) && this.generateBiomeBlocks) {
            this.replaceBiomeBlocks(x, z, chunkprimer, this.biomesForGeneration);
        }
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void generateTerrain(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.regionRand.setSeed((long)((int)Math.floor((double)chunkX * 16.0 / (double)this.regionSize)) * 341873128712L + (long)((int)Math.floor((double)chunkZ * 16.0 / (double)this.regionSize)) * 132897987541L);
        int regionCenterX = (int)Math.floor((double)chunkX * 16.0 / (double)this.regionSize) * this.regionSize + this.regionSize / 2;
        int regionCenterZ = (int)Math.floor((double)chunkZ * 16.0 / (double)this.regionSize) * this.regionSize + this.regionSize / 2;
        int randomSpace = this.regionSize - this.maxIslandRadius * 2;
        int islandCenterX = this.regionRand.nextInt(randomSpace) - randomSpace / 2 + regionCenterX;
        int islandCenterZ = this.regionRand.nextInt(randomSpace) - randomSpace / 2 + regionCenterZ;
        int islandTopThickness = 10;
        int islandHeight = (int)((double)(this.maxIslandRadius + 10) * this.yBottomStretch) + this.minIslandHeight;
        int islandHeightRandom = this.maxIslandHeight - islandHeight - this.minIslandHeight;
        int islandHeightOffset = 0;
        if (islandHeightRandom > 0) {
            islandHeightOffset = this.regionRand.nextInt(islandHeightRandom) + this.minIslandHeight;
        }
        int islandMinY = this.minIslandHeight;
        int islandMaxY = islandHeight;
        int chunkBlockX = chunkX * 16;
        int chunkBlockZ = chunkZ * 16;
        double islandMid = (double)(islandMaxY - islandMinY) / 2.0;
        for (int x = 0; x < 16; ++x) {
            int realX = x + chunkBlockX;
            double xDistance = (double)Math.abs(islandCenterX - realX) / this.xStretch;
            if (!(xDistance <= (double)this.maxIslandRadius)) continue;
            double xPow = Math.pow(xDistance, 2.0);
            for (int z = 0; z < 16; ++z) {
                int realZ = z + chunkBlockZ;
                double zDistance = (double)Math.abs(islandCenterZ - realZ) / this.zStretch;
                if (!(zDistance <= (double)this.maxIslandRadius)) continue;
                double zPow = Math.pow(zDistance, 2.0);
                for (int y = 0; y < islandMaxY; ++y) {
                    double yPow = y > islandMaxY - 10 ? Math.pow((double)(islandMaxY - 10 - y) * (1.0 - (islandMid - (double)y) / islandMid + 1.0) * 1.5, 2.0) : Math.pow((double)(islandMaxY - 10 - y) / this.yBottomStretch, 2.0);
                    double distance = Math.sqrt(xPow + zPow + yPow);
                    double distanceD = ((double)this.maxIslandRadius - distance) / (double)this.maxIslandRadius * (1.0 - this.minBlockValue) + this.minBlockValue;
                    double noise = this.islandNoiseGen.eval((double)realX / this.noiseSizeX, (double)y / this.noiseSizeY, (double)realZ / this.noiseSizeZ, this.noiseOctaves, this.noisePersistence);
                    double density = noise * distanceD;
                    if (!(density > this.minBlockValue)) continue;
                    primer.func_177855_a(x, y + islandHeightOffset, z, this.mainBlock);
                }
            }
        }
    }

    public void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomesIn[j + i * 16];
                this.genBiomeTerrainBlocks(biome, this.worldObj, this.rand, primer, x * 16 + i, z * 16 + j, this.depthBuffer[j + i * 16]);
            }
        }
    }

    public void genBiomeTerrainBlocks(Biome biome, World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        int i = worldIn.func_181545_F();
        IBlockState iblockstate = biome.field_76752_A;
        IBlockState iblockstate1 = biome.field_76753_B;
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int l = x & 0xF;
        int i1 = z & 0xF;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j1 = 255; j1 >= 0; --j1) {
            IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
            if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                j = -1;
                continue;
            }
            if (iblockstate2 != this.mainBlock) continue;
            if (j == -1) {
                if (k <= 0) {
                    iblockstate = AIR;
                    iblockstate1 = this.mainBlock;
                } else if (j1 >= i - 4 && j1 <= i + 1) {
                    iblockstate = biome.field_76752_A;
                    iblockstate1 = biome.field_76753_B;
                }
                if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                    iblockstate = biome.func_180626_a((BlockPos)blockpos$mutableblockpos.func_181079_c(x, j1, z)) < 0.15f ? ICE : WATER;
                }
                j = k;
                if (j1 >= i - 1) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate);
                    continue;
                }
                if (j1 < i - 7 - k) {
                    iblockstate = AIR;
                    iblockstate1 = this.mainBlock;
                    chunkPrimerIn.func_177855_a(i1, j1, l, GRAVEL);
                    continue;
                }
                chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
                continue;
            }
            if (j <= 0) continue;
            chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
            if (--j != 0 || iblockstate1.func_177230_c() != Blocks.field_150354_m || k <= 1) continue;
            j = rand.nextInt(4) + Math.max(0, j1 - 63);
            iblockstate1 = iblockstate1.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? RED_SANDSTONE : SANDSTONE;
        }
    }

    @Override
    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.worldObj.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.worldObj.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * k + (long)z * l ^ this.worldObj.func_72905_C());
        boolean flag = false;
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)flag);
        if (this.populateLakes && biome != Biomes.field_76769_d && biome != Biomes.field_76786_s && this.settings.field_177781_A && !flag && this.rand.nextInt(this.settings.field_177782_B) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            int i1 = this.rand.nextInt(16) + 8;
            int j1 = this.rand.nextInt(256);
            int k1 = this.rand.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.worldObj, this.rand, blockpos.func_177982_a(i1, j1, k1));
        }
        if (this.populateLavaLakes && !flag && this.rand.nextInt(this.settings.field_177777_D / 10) == 0 && this.settings.field_177783_C && TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
            int i2 = this.rand.nextInt(16) + 8;
            int l2 = this.rand.nextInt(this.rand.nextInt(248) + 8);
            int k3 = this.rand.nextInt(16) + 8;
            if (l2 < this.worldObj.func_181545_F() || this.rand.nextInt(this.settings.field_177777_D / 8) == 0) {
                new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.worldObj, this.rand, blockpos.func_177982_a(i2, l2, k3));
            }
        }
        if (this.decorateBiomes) {
            biome.func_180624_a(this.worldObj, this.rand, new BlockPos(i, 0, j));
        }
        if (this.populateAnimals && TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.worldObj, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.rand);
        }
        blockpos = blockpos.func_177982_a(8, 0, 8);
        if (this.populateIce && TerrainGen.populate((IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int j3 = 0; j3 < 16; ++j3) {
                    BlockPos blockpos1 = this.worldObj.func_175725_q(blockpos.func_177982_a(k2, 0, j3));
                    BlockPos blockpos2 = blockpos1.func_177977_b();
                    if (this.worldObj.func_175675_v(blockpos2)) {
                        this.worldObj.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                    }
                    if (!this.worldObj.func_175708_f(blockpos1, true)) continue;
                    this.worldObj.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 2);
                }
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)flag);
        BlockFalling.field_149832_M = false;
    }

    public BlockPos getIslandLocationForRegion(BlockPos regionPos) {
        this.regionRand.setSeed((long)regionPos.func_177958_n() * 341873128712L + (long)regionPos.func_177952_p() * 132897987541L);
        int regionCenterX = regionPos.func_177958_n() * this.regionSize + this.regionSize / 2;
        int regionCenterZ = regionPos.func_177952_p() * this.regionSize + this.regionSize / 2;
        int randomSpace = this.regionSize - this.maxIslandRadius * 2;
        int islandCenterX = this.regionRand.nextInt(randomSpace) - randomSpace / 2 + regionCenterX;
        int islandCenterZ = this.regionRand.nextInt(randomSpace) - randomSpace / 2 + regionCenterZ;
        return new BlockPos(islandCenterX, 0, islandCenterZ);
    }
}

