/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.world.chunkgenerator;

import com.bloodnbonesgaming.dimensionalcontrol.config.chunkprovider.ChunkGeneratorDefinitionOverride;
import com.bloodnbonesgaming.dimensionalcontrol.config.data.BiomeData;
import com.bloodnbonesgaming.dimensionalcontrol.util.MathHelper;
import com.bloodnbonesgaming.dimensionalcontrol.util.noise.OpenSimplexNoiseGeneratorOctaves;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkGeneratorOverworldCustom
implements IChunkGenerator {
    final Random rand = new Random();
    final World world;
    Biome[] biomesForGeneration;
    protected final OpenSimplexNoiseGeneratorOctaves terrainNoise;
    final Random mountainRand = new Random();
    double[] heightMap = new double[825];
    double[] largeNoiseArray = new double[65536];
    final ChunkGeneratorDefinitionOverride definition;
    public ChunkGeneratorSettings settings;
    public double[] depthBuffer = new double[256];

    public ChunkGeneratorOverworldCustom(World world, String generatorOptions, ChunkGeneratorDefinitionOverride definition) {
        this.world = world;
        this.terrainNoise = new OpenSimplexNoiseGeneratorOctaves(world.func_72905_C());
        if (generatorOptions != null) {
            this.settings = ChunkGeneratorSettings.Factory.func_177865_a((String)generatorOptions).func_177864_b();
        }
        this.definition = definition;
    }

    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkPrimer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, chunkPrimer);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.replaceBiomeBlocks(x, z, chunkPrimer, this.biomesForGeneration);
        Chunk chunk = new Chunk(this.world, chunkPrimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void generateNoise(int chunkX, int chunkZ, double[] array, int arraySizeX, int arraySizeY, int arraySizeZ, double x, double y, double z, int octaves, double persistence, int xCoordinateScale, int yCoordinateScale, int zCoordinateScale, double xScale, double yScale, double zScale) {
        for (int xI = 0; xI < arraySizeX; ++xI) {
            for (int zI = 0; zI < arraySizeZ; ++zI) {
                for (int yI = 0; yI < arraySizeY; ++yI) {
                    double noiseSkew;
                    int index = (xI * arraySizeX + zI) * arraySizeY + yI;
                    double d3noise = this.terrainNoise.eval((x + (double)(xI * xCoordinateScale)) / xScale, (y + (double)(yI * yCoordinateScale)) / yScale, (z + (double)(zI * zCoordinateScale)) / zScale, octaves, persistence) * 2.0 - 1.0;
                    array[index] = noiseSkew = d3noise * 16.0;
                }
            }
        }
    }

    public void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        this.generateNoise(chunkX, chunkZ, this.heightMap, 5, 33, 5, chunkX * 16, 0.0, chunkZ * 16, 3, 0.5, 4, 8, 4, 64.0, 32.0, 64.0);
        MathHelper.interpolate(this.heightMap, this.largeNoiseArray, 5, 33, 5, 4, 8, 4);
        for (int x = 0; x < 16; ++x) {
            int realX = chunkX * 16 + x;
            for (int z = 0; z < 16; ++z) {
                int realZ = chunkZ * 16 + z;
                double largeTotalHeightVariation = 0.0;
                double largeTotalBaseHeight = 0.0;
                int largeTotalBiomes = 0;
                for (int xI = -32; xI <= 32; ++xI) {
                    for (int zI = -32; zI <= 32; ++zI) {
                        ++largeTotalBiomes;
                        double biomeX = realX + xI;
                        double biomeZ = realZ + zI;
                        Biome biome = this.world.func_72959_q().func_180631_a(new BlockPos(biomeX, 0.0, biomeZ));
                        BiomeData data = this.definition.getOrMakeDataForBiome(biome);
                        double heightVariation = data.getHeightVariation() != null ? (double)data.getHeightVariation().floatValue() : (double)biome.func_185360_m();
                        double baseHeight = data.getBaseHeight() != null ? (double)data.getBaseHeight().floatValue() : (double)biome.func_185355_j();
                        heightVariation = Math.max(heightVariation, 0.1);
                        largeTotalHeightVariation += heightVariation;
                        largeTotalBaseHeight += baseHeight;
                    }
                }
                double largeHeightVariation = largeTotalHeightVariation / (double)largeTotalBiomes;
                double largeBaseHeight = largeTotalBaseHeight / (double)largeTotalBiomes;
                double totalHeightVariation = 0.0;
                double totalBaseHeight = 0.0;
                int totalBiomes = 0;
                for (int xI = -4; xI <= 4; ++xI) {
                    for (int zI = -4; zI <= 4; ++zI) {
                        ++totalBiomes;
                        double biomeX = realX + xI;
                        double biomeZ = realZ + zI;
                        Biome biome = this.world.func_72959_q().func_180631_a(new BlockPos(biomeX, 0.0, biomeZ));
                        BiomeData data = this.definition.getOrMakeDataForBiome(biome);
                        double heightVariation = data.getHeightVariation() != null ? (double)data.getHeightVariation().floatValue() : (double)biome.func_185360_m();
                        double baseHeight = data.getBaseHeight() != null ? (double)data.getBaseHeight().floatValue() : (double)biome.func_185355_j();
                        heightVariation = Math.max(heightVariation, 0.1);
                        totalHeightVariation += heightVariation;
                        totalBaseHeight += baseHeight;
                    }
                }
                double heightVariation = (totalHeightVariation / (double)totalBiomes + largeHeightVariation) / 2.0;
                double baseHeight = (totalBaseHeight / (double)totalBiomes + largeBaseHeight) / 2.0;
                for (int y = 0; y < 256; ++y) {
                    double d3noise = this.largeNoiseArray[(x * 16 + z) * 256 + y];
                    double d2noise = this.terrainNoise.eval(((double)realX + d3noise) / 255.0, ((double)realZ + d3noise) / 255.0, 5, 0.75);
                    double height = d2noise * (heightVariation * 130.0) + 60.0 + baseHeight * 16.0;
                    if ((double)y <= height) {
                        primer.func_177855_a(x, y, z, Blocks.field_150348_b.func_176223_P());
                        continue;
                    }
                    if (y >= 64) continue;
                    primer.func_177855_a(x, y, z, Blocks.field_150355_j.func_176223_P());
                }
            }
        }
    }

    public void generateTerrain(int chunkX, int chunkZ, ChunkPrimer primer) {
        for (int x = 0; x < 16; ++x) {
            int realX = x + chunkX * 16;
            for (int z = 0; z < 16; ++z) {
                int realZ = z + chunkZ * 16;
                int height = 64;
                for (int y = 0; y < 256; ++y) {
                    if (y > 64) continue;
                }
            }
        }
    }

    public void generateMountainFeatures(int chunkX, int chunkZ, ChunkPrimer primer) {
        int regionSize = 300;
        double maxFeatureRadius = 100.0;
        double maxHeight = 128.0;
        this.mountainRand.setSeed((long)((int)Math.floor((double)chunkX * 16.0 / 300.0)) * 341873128712L + (long)((int)Math.floor((double)chunkZ * 16.0 / 300.0)) * 132897987541L);
        int regionCenterX = (int)Math.floor((double)chunkX * 16.0 / 300.0) * 300 + 150;
        int regionCenterZ = (int)Math.floor((double)chunkZ * 16.0 / 300.0) * 300 + 150;
        int randomSpace = 100;
        int featureCenterX = this.mountainRand.nextInt(100) - 50 + regionCenterX;
        int featureCenterZ = this.mountainRand.nextInt(100) - 50 + regionCenterZ;
        int chunkBlockX = chunkX * 16;
        int chunkBlockZ = chunkZ * 16;
        for (double x = 0.0; x < 16.0; x += 1.0) {
            double realX = x + (double)chunkBlockX;
            double xDistance = Math.pow(Math.abs((double)featureCenterX - realX), 2.0);
            for (double z = 0.0; z < 16.0; z += 1.0) {
                double realZ = z + (double)chunkBlockZ;
                double zDistance = Math.pow(Math.abs((double)featureCenterZ - realZ), 2.0);
                for (double y = 0.0; y < 256.0; y += 1.0) {
                    double skewNoise = this.terrainNoise.eval(realX / 128.0, y / 32.0, realZ / 128.0, 3, 0.5) * 2.0 - 1.0;
                    double skewedXDistance = Math.pow(Math.abs((double)featureCenterX - (realX + 32.0 * skewNoise)), 2.0);
                    double skewedZDistance = Math.pow(Math.abs((double)featureCenterZ - (realZ + 32.0 * skewNoise)), 2.0);
                    double yDistance = Math.pow(Math.abs(128.0 - y), 2.0);
                    double distanceD = Math.sqrt(xDistance + yDistance + zDistance);
                    if (!(128.0 - y >= 1.28 * Math.sqrt(skewedXDistance + skewedZDistance)) || !(y < 128.0)) continue;
                    primer.func_177855_a((int)x, (int)y, (int)z, Blocks.field_150348_b.func_176223_P());
                }
            }
        }
    }

    public void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)x, (int)z, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        double d0 = 0.03125;
        this.terrainNoise.eval(this.depthBuffer, 16, 1, 16, x * 16, 0.0, z * 16, 3, 0.5, 1, 1, 1, 64.0, 0.0, 64.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomesIn[j + i * 16];
                biome.func_180622_a(this.world, this.rand, primer, x * 16 + i, z * 16 + j, this.depthBuffer[j + i * 16]);
            }
        }
    }

    public void func_185931_b(int x, int z) {
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        boolean flag = false;
        ChunkPos chunkpos = new ChunkPos(x, z);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag);
        if (biome != Biomes.field_76769_d && biome != Biomes.field_76786_s && this.settings.field_177781_A && !flag && this.rand.nextInt(this.settings.field_177782_B) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            int i1 = this.rand.nextInt(16) + 8;
            int j1 = this.rand.nextInt(256);
            int k1 = this.rand.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.rand, blockpos.func_177982_a(i1, j1, k1));
        }
        if (!flag && this.rand.nextInt(this.settings.field_177777_D / 10) == 0 && this.settings.field_177783_C && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
            int i2 = this.rand.nextInt(16) + 8;
            int l2 = this.rand.nextInt(this.rand.nextInt(248) + 8);
            int k3 = this.rand.nextInt(16) + 8;
            if (l2 < this.world.func_181545_F() || this.rand.nextInt(this.settings.field_177777_D / 8) == 0) {
                new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.world, this.rand, blockpos.func_177982_a(i2, l2, k3));
            }
        }
        if (this.settings.field_177837_s && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
            for (int j2 = 0; j2 < this.settings.field_177835_t; ++j2) {
                int i3 = this.rand.nextInt(16) + 8;
                int l3 = this.rand.nextInt(256);
                int l1 = this.rand.nextInt(16) + 8;
                new WorldGenDungeons().func_180709_b(this.world, this.rand, blockpos.func_177982_a(i3, l3, l1));
            }
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.rand);
        }
        blockpos = blockpos.func_177982_a(8, 0, 8);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int j3 = 0; j3 < 16; ++j3) {
                    BlockPos blockpos1 = this.world.func_175725_q(blockpos.func_177982_a(k2, 0, j3));
                    BlockPos blockpos2 = blockpos1.func_177977_b();
                    if (this.world.func_175675_v(blockpos2)) {
                        this.world.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                    }
                    if (!this.world.func_175708_f(blockpos1, true)) continue;
                    this.world.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 2);
                }
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)flag);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return null;
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

