/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.events;

import com.bloodnbonesgaming.dimensionalcontrol.block.ModBlocks;
import com.bloodnbonesgaming.dimensionalcontrol.blockreplacement.BlockReplacer;
import com.bloodnbonesgaming.dimensionalcontrol.blockreplacement.GenerationPoint;
import com.bloodnbonesgaming.dimensionalcontrol.config.ConfigurationManager;
import com.bloodnbonesgaming.dimensionalcontrol.config.PortalDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.world.chunkgenerator.ChunkGeneratorSkyIdealistic;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class DCEventHandler {
    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            IBlockState state = event.getEntity().field_70170_p.func_180495_p(event.getPos());
            PortalDefinition definition = ConfigurationManager.getInstance().getPortalDefinition(event.getEntity().field_70170_p.field_73011_w.getDimension(), state, event.getItemStack());
            if (definition != null && ModBlocks.blockDimensionalPortal.trySpawnPortal(event.getEntity().field_70170_p, event.getPos().func_177972_a(EnumFacing.UP), definition, ConfigurationManager.getInstance().getPortalDefinitionID(definition))) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBiomeBlockReplacement(ChunkGeneratorEvent.ReplaceBiomeBlocks event) {
        if (event.getWorld() != null) {
            BlockReplacer.replaceBlocks(GenerationPoint.BIOME_BLOCK_REPLACEMENT, (WorldServer)event.getWorld(), event.getPrimer(), event.getX() * 16, event.getZ() * 16);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPopulateChunkPre(PopulateChunkEvent.Pre event) {
        BlockReplacer.replaceBlocks(GenerationPoint.POPULATE_CHUNK_PRE, (WorldServer)event.getWorld(), event.getChunkX() * 16, event.getChunkZ() * 16);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPopulateChunkPost(PopulateChunkEvent.Post event) {
        BlockReplacer.replaceBlocks(GenerationPoint.POPULATE_CHUNK_POST, (WorldServer)event.getWorld(), event.getChunkX() * 16, event.getChunkZ() * 16);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDecorateBiomePre(DecorateBiomeEvent.Pre event) {
        BlockReplacer.replaceBlocks(GenerationPoint.DECORATE_CHUNK_PRE, (WorldServer)event.getWorld(), event.getPos().func_177958_n(), event.getPos().func_177952_p());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDecorateBiomePost(DecorateBiomeEvent.Post event) {
        BlockReplacer.replaceBlocks(GenerationPoint.DECORATE_CHUNK_POST, (WorldServer)event.getWorld(), event.getPos().func_177958_n(), event.getPos().func_177952_p());
    }

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        ModBlocks.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public void onCreateSpawn(WorldEvent.CreateSpawnPosition event) {
        IChunkGenerator generator = ((ChunkProviderServer)event.getWorld().func_72863_F()).field_186029_c;
        if (generator instanceof ChunkGeneratorSkyIdealistic) {
            ChunkGeneratorSkyIdealistic skyGenerator = (ChunkGeneratorSkyIdealistic)generator;
            event.setCanceled(true);
            event.getWorld().field_72986_A.func_176143_a(skyGenerator.getIslandLocationForRegion(new BlockPos(0, 0, 0)));
        }
    }
}

