/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.config.data;

import com.bloodnbonesgaming.dimensionalcontrol.config.data.EnchantmentData;
import com.bloodnbonesgaming.dimensionalcontrol.config.data.MinMaxBoundsData;
import com.bloodnbonesgaming.dimensionalcontrol.config.data.predicate.ExtendedItemPredicate;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.NBTPredicate;
import net.minecraft.item.Item;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.potion.PotionType;
import net.minecraftforge.oredict.OreDictionary;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/dataObjects/ItemData", classExplaination="These are the functions which can be called on an ItemData object.")
public class ItemData {
    private Item item;
    private Integer meta;
    private final MinMaxBoundsData count = new MinMaxBoundsData();
    private final MinMaxBoundsData durability = new MinMaxBoundsData();
    private final EnchantmentData enchantmentData = new EnchantmentData();
    private PotionType potionType;
    private NBTPredicate nbt = NBTPredicate.field_193479_a;
    private String oreDict;

    public ItemPredicate buildItemPredicate() {
        return new ExtendedItemPredicate(this.item, this.meta, this.count.buildBounds(), this.durability.buildBounds(), new EnchantmentPredicate[0], this.potionType, this.nbt, this.oreDict);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max stack count.")
    public void setCountMinMax(float min, float max) {
        this.count.setMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min stack count.")
    public void setCountMin(float min) {
        this.count.setMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max stack count.")
    public void setCountMax(float max) {
        this.count.setMax(max);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max durability.")
    public void setDurabilityMinMax(float min, float max) {
        this.durability.setMinMax(min, max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min durability.")
    public void setDurabilityMin(float min) {
        this.durability.setMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max durability.")
    public void setDurabilityMax(float max) {
        this.durability.setMax(max);
    }

    @ScriptMethodDocumentation(args="String", usage="item name", notes="Sets the item. This counts for any meta.")
    public void setItem(String itemName) throws Exception {
        this.setItem(itemName, null);
    }

    @ScriptMethodDocumentation(args="String, Integer", usage="item name, meta", notes="Sets the item with the provided meta.")
    public void setItem(String itemName, Integer meta) throws Exception {
        Item item = Item.func_111206_d((String)itemName);
        if (item == null) {
            throw new Exception(itemName + " is not a valid item name!");
        }
        this.item = item;
        this.meta = meta;
    }

    @ScriptMethodDocumentation(args="String, Integer, String", usage="item name, meta, NBT Json", notes="Sets the item with the provided meta and NBT.")
    public void setItem(String itemName, Integer meta, String nbtJson) throws Exception {
        this.setItem(itemName, meta);
        this.setNBT(nbtJson);
    }

    @ScriptMethodDocumentation(args="String", usage="enchantment path", notes="Sets the enchantment.")
    public void setEnchantment(String enchantment) {
        this.enchantmentData.setEnchantment(enchantment);
    }

    @ScriptMethodDocumentation(args="float, float", usage="min, max", notes="Sets the min and max enchantment levels.")
    public void setEnchantmentLevelsMinMax(float min, float max) {
        this.setEnchantmentLevelsMin(min);
        this.setEnchantmentLevelsMax(max);
    }

    @ScriptMethodDocumentation(args="float", usage="min", notes="Sets the min enchantment level.")
    public void setEnchantmentLevelsMin(float min) {
        this.enchantmentData.setLevelsMin(min);
    }

    @ScriptMethodDocumentation(args="float", usage="max", notes="Sets the max enchantment level.")
    public void setEnchantmentLevelsMax(float max) {
        this.enchantmentData.setLevelsMax(max);
    }

    @ScriptMethodDocumentation(args="String", usage="potion type", notes="Sets the potion type.")
    public void setPotionType(String type) {
        this.potionType = PotionType.func_185168_a((String)type);
    }

    @ScriptMethodDocumentation(args="String", usage="NBT Json", notes="Sets the NBT from the provided Json string.")
    public void setNBT(String nbtJson) throws Exception {
        this.nbt = new NBTPredicate(JsonToNBT.func_180713_a((String)nbtJson));
    }

    @ScriptMethodDocumentation(args="String", usage="ore dict name", notes="Sets the ore dictionary.")
    public void setOreDict(String oreDict) throws Exception {
        if (!OreDictionary.doesOreNameExist((String)oreDict)) {
            throw new Exception("Ore dictionary " + oreDict + " does not exist!");
        }
        this.oreDict = oreDict;
    }
}

