/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.config.biomeprovider;

import com.bloodnbonesgaming.dimensionalcontrol.DimensionalControl;
import com.bloodnbonesgaming.dimensionalcontrol.config.biomeprovider.BiomeProviderDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.util.BiomeProviderType;
import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/biomeproviders/Single", classExplaination="The role of a BiomeProvider is to handle the generation of the dimensions biome map. This particular type uses only a single biome, and is what is used for the Nether and the End.")
public class BiomeProviderDefinitionSingle
extends BiomeProviderDefinition {
    private Biome biome = Biomes.field_76771_b;

    public BiomeProviderDefinitionSingle(BiomeProviderType type) {
        super(type);
    }

    public Biome getBiome() {
        return this.biome;
    }

    @ScriptMethodDocumentation(usage="biome ID", notes="Sets the single biome to be used for this BiomeProvider as the provided biome ID.")
    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    public void setBiome(int biomeID) {
        Biome biome = Biome.func_150568_d((int)biomeID);
        if (biome != null) {
            this.biome = biome;
        } else {
            DimensionalControl.instance.getLog().error((Object)(biome + " is not a biome ID."));
        }
    }
}

