/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.config;

import com.bloodnbonesgaming.dimensionalcontrol.DimensionalControl;
import com.bloodnbonesgaming.dimensionalcontrol.config.ClientConfigs;
import com.bloodnbonesgaming.dimensionalcontrol.config.DefaultConfigs;
import com.bloodnbonesgaming.dimensionalcontrol.config.DimensionDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.config.MainConfig;
import com.bloodnbonesgaming.dimensionalcontrol.config.PortalDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.config.WorldInfoDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.config.data.ItemData;
import com.bloodnbonesgaming.dimensionalcontrol.util.BiomePrinter;
import com.bloodnbonesgaming.dimensionalcontrol.util.IOHelper;
import com.bloodnbonesgaming.lib.BNBGamingLib;
import com.bloodnbonesgaming.lib.util.script.ClientOnly;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptDocumentationHandler;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/Dimensions", classExplaination="The main purpose of this file is to register new dimensions and set script configs for them. It is also where WorldInfo scripts and BiomePrinters are set.")
public class ConfigurationManager {
    private static ConfigurationManager instance;
    private final String preset;
    private final File configFolder;
    private final Map<Integer, DimensionType> dimensionMapCopy = new HashMap<Integer, DimensionType>();
    private final Map<Integer, DimensionDefinition> dimensionDefinitions = new HashMap<Integer, DimensionDefinition>();
    private final MainConfig mainConfig = new MainConfig();
    private final List<BiomePrinter> biomePrinters = new ArrayList<BiomePrinter>();
    private final List<Integer> dimensionsToRegister = new ArrayList<Integer>();
    private WorldInfoDefinition globalWorldInfo = new WorldInfoDefinition();
    private boolean worldInfoChanged = false;
    private final Map<Integer, WorldInfoDefinition> worldInfoMap = new HashMap<Integer, WorldInfoDefinition>();
    private ItemPredicate portalIgniter;
    private ItemData portalIgniterData;
    private final PortalDefinition[] portalDefinitions = new PortalDefinition[256];
    private final ClientConfigs clientConfigs = BNBGamingLib.proxy.client() ? new ClientConfigs() : null;

    private ConfigurationManager(String preset) {
        this.preset = preset;
        this.configFolder = new File(preset.equalsIgnoreCase("Default") ? "./config/dimensionalcontrol/" : "./config/dimensionalcontrol/presets/" + preset + "/");
    }

    public String getPreset() {
        return this.preset;
    }

    public File getConfigFile(String fileName) {
        return new File(this.configFolder, fileName);
    }

    @ClientOnly
    @ScriptMethodDocumentation(usage="", notes="Gets the ClientConfigs object. Documentation for it can be found in documention/ClientConfigs.txt")
    public ClientConfigs getClientConfigs() {
        return this.clientConfigs;
    }

    @ScriptMethodDocumentation(args="String", usage="item name", notes="Sets the portal igniter. This is the item that will be used to ignite any custom portals. This counts for any meta. Returns the ItemData object for the portal igniter.")
    public ItemData setPortalIgniter(String itemName) throws Exception {
        return this.setPortalIgniter(itemName, null);
    }

    @ScriptMethodDocumentation(args="String, Integer", usage="item name, meta", notes="Sets the portal igniter with the provided meta. This is the item that will be used to ignite any custom portals. Returns the ItemData object for the portal igniter.")
    public ItemData setPortalIgniter(String itemName, Integer meta) throws Exception {
        ItemData data = this.getPortalIgniterData();
        data.setItem(itemName, meta);
        return data;
    }

    @ScriptMethodDocumentation(args="String, Integer, String", usage="item name, meta, NBT Json", notes="Sets the portal igniter with the provided meta and NBT. This is the item that will be used to ignite any custom portals. Returns the ItemData object for the portal igniter.")
    public ItemData setPortalIgniter(String itemName, Integer meta, String nbtJson) throws Exception {
        ItemData data = this.getPortalIgniterData();
        data.setItem(itemName, meta, nbtJson);
        return data;
    }

    @ScriptMethodDocumentation(args="String", usage="ore dict name", notes="Sets the ore dictionary for the portal igniter. Any item from this ore dict will be usable to ignite custom portals. Returns the ItemData object for the portal igniter.")
    public ItemData setPortalIgniterOreDict(String oreDict) throws Exception {
        ItemData data = this.getPortalIgniterData();
        data.setOreDict(oreDict);
        return data;
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the ItemData object for the portal igniter so functions can be called on it.")
    public ItemData getPortalIgniterData() {
        if (this.portalIgniterData == null) {
            this.portalIgniterData = new ItemData();
        }
        return this.portalIgniterData;
    }

    @ScriptMethodDocumentation(args="byte, String", usage="portal id, item name", notes="Sets the portal igniter for the provided portal id. This is the item that will be used to ignite the custom portal. This counts for any meta. Returns the ItemData object for the portal igniter.")
    public ItemData setPortalIgniter(byte portalID, String itemName) throws Exception {
        return this.setPortalIgniter(portalID, itemName, null);
    }

    @ScriptMethodDocumentation(args="byte, String, Integer", usage="portal id, item name, meta", notes="Sets the portal igniter with the provided meta for the provided portal id. This is the item that will be used to ignite the custom portal. Returns the ItemData object for the portal igniter.")
    public ItemData setPortalIgniter(byte portalID, String itemName, Integer meta) throws Exception {
        ItemData data = this.getOrMakePortalDefinition(portalID).getIgniter();
        data.setItem(itemName, meta);
        return data;
    }

    @ScriptMethodDocumentation(args="byte, String, Integer, String", usage="portal id, item name, meta, NBT Json", notes="Sets the portal igniter with the provided meta and NBT for the provided portal id. This is the item that will be used to ignite the custom portal. Returns the ItemData object for the portal igniter.")
    public ItemData setPortalIgniter(byte portalID, String itemName, Integer meta, String nbtJson) throws Exception {
        ItemData data = this.getOrMakePortalDefinition(portalID).getIgniter();
        data.setItem(itemName, meta, nbtJson);
        return data;
    }

    @ScriptMethodDocumentation(args="byte, String", usage="portal id, ore dict name", notes="Sets the ore dictionary for the portal igniter for the provided portal id. Any item from this ore dict will be usable to ignite the custom portal. Returns the ItemData object for the portal igniter.")
    public ItemData setPortalIgniterOreDict(byte portalID, String oreDict) throws Exception {
        ItemData data = this.getOrMakePortalDefinition(portalID).getIgniter();
        data.setOreDict(oreDict);
        return data;
    }

    @ScriptMethodDocumentation(args="byte", usage="portal id", notes="Returns the ItemData object for the portal igniter for the provided portal id so functions can be called on it.")
    public ItemData getPortalIgniterData(byte portalID) {
        return this.getOrMakePortalDefinition(portalID).getIgniter();
    }

    public ItemPredicate getPortalIgniter() {
        if (this.portalIgniter == null && this.portalIgniterData != null) {
            this.portalIgniter = this.portalIgniterData.buildItemPredicate();
        }
        return this.portalIgniter;
    }

    @ScriptMethodDocumentation(args="byte, int, int, String", usage="portal ID, first dimension ID, second dimension ID, block ID", notes="Sets the portal of the provided id to be made of the provided block with any meta and travel between the two provided dimensions. Portal ID can be set to anything between -128 and 127. The auto generated portal will be created using the default state of the provided block.")
    public void setPortal(byte id, int dimensionID1, int dimensionID2, String blockID) throws Exception {
        this.setPortal(id, dimensionID1, dimensionID2, blockID, null);
    }

    @ScriptMethodDocumentation(args="byte, int, int, String", usage="portal ID, first dimension ID, second dimension ID, block ID", notes="Sets the portal of the provided id to be made of the provided block with the provided meta and travel between the two provided dimensions. Portal ID can be set to anything between -128 and 127")
    public void setPortal(byte id, int dimensionID1, int dimensionID2, String blockID, Integer meta) throws Exception {
        PortalDefinition definition = this.getOrMakePortalDefinition(id);
        definition.setDimension(dimensionID1, dimensionID2);
        definition.setBlock(blockID, meta);
    }

    @ScriptMethodDocumentation(args="byte, int, int, String", usage="portal ID, first dimension ID, second dimension ID, oredict ID", notes="Sets the portal of the provided id to be made of blocks from the provided oredict and travel between the two provided dimensions. Portal ID can be set to anything between -128 and 127. The auto generated portal will be created using the default state of the first block in the oredict.")
    public void setPortalOreDict(byte id, int dimensionID1, int dimensionID2, String oreDict) throws Exception {
        PortalDefinition definition = this.getOrMakePortalDefinition(id);
        definition.setDimension(dimensionID1, dimensionID2);
        definition.setOreDict(oreDict);
    }

    public byte getPortalDefinitionID(PortalDefinition definition) {
        for (int i = 0; i < 256; ++i) {
            if (this.portalDefinitions[i] != definition) continue;
            return (byte)(i - 128);
        }
        return 0;
    }

    public PortalDefinition getOrMakePortalDefinition(byte id) {
        PortalDefinition definition = this.getPortalDefinition(id);
        if (definition == null) {
            this.portalDefinitions[id + 128] = definition = new PortalDefinition();
        }
        return definition;
    }

    public PortalDefinition getPortalDefinition(byte id) {
        return this.portalDefinitions[id + 128];
    }

    public PortalDefinition getPortalDefinition(int dimensionID, IBlockState state, ItemStack stack) {
        ItemPredicate globalIgniter = ConfigurationManager.getInstance().getPortalIgniter();
        for (PortalDefinition definition : this.portalDefinitions) {
            if (definition == null || definition.getDimensionID1() != dimensionID && definition.getDimensionID2() != dimensionID || !definition.correctBlock(state)) continue;
            ItemPredicate igniter = definition.getIgniterPredicate();
            if (igniter == null) {
                igniter = globalIgniter;
            }
            if (igniter == null || !igniter.func_192493_a(stack)) continue;
            return definition;
        }
        return null;
    }

    public boolean isWorldInfoChanged() {
        return this.worldInfoChanged;
    }

    @ScriptMethodDocumentation(usage="", notes="Sets the global WorldInfoDefinition object and returns it, so functions can be called on it. The same functions that can be called in a worldinfo script, can be called on this object. Documentation can be found in documentation/worldinfo/WorldInfo.txt")
    public WorldInfoDefinition setGlobalWorldInfoDefinition() {
        WorldInfoDefinition definition;
        this.globalWorldInfo = definition = new WorldInfoDefinition();
        this.worldInfoChanged = true;
        return definition;
    }

    @ScriptMethodDocumentation(args="String", usage="script name", notes="Sets the script to be used for global world info options.")
    public void setGlobalWorldInfo(String script) {
        IOHelper.loadWorldInfoDefinition(script, this.globalWorldInfo);
        this.worldInfoChanged = true;
    }

    @ScriptMethodDocumentation(args="int", usage="dimension ID", notes="Sets the WorldInfoDefinition object for the provided dimensionID and returns it, so functions can be called on it. The same functions that can be called in a worldinfo script, can be called on this object. Documentation can be found in documentation/worldinfo/WorldInfo.txt")
    public WorldInfoDefinition setWorldInfoDefinition(int dimensionID) {
        WorldInfoDefinition definition = new WorldInfoDefinition();
        this.worldInfoMap.put(dimensionID, definition);
        return definition;
    }

    @ScriptMethodDocumentation(args="int, WorldInfoDefinition", usage="dimension ID, definition", notes="Sets the WorldInfoDefinition for the provided dimensionID.")
    public WorldInfoDefinition setWorldInfoDefinition(int dimensionID, WorldInfoDefinition definition) {
        this.worldInfoMap.put(dimensionID, definition);
        return definition;
    }

    @ScriptMethodDocumentation(args="String, int", usage="script name, dimension ID", notes="Sets the script to be used for the provided dimensions world info options.")
    public void setWorldInfoForDimension(String script, int dimensionID) {
        WorldInfoDefinition definition = new WorldInfoDefinition();
        IOHelper.loadWorldInfoDefinition(script, definition);
        if (definition != null) {
            this.worldInfoMap.put(dimensionID, definition);
        }
    }

    public WorldInfoDefinition getWorldInfoDefinition(int dimensionID) {
        return this.worldInfoMap.get(dimensionID);
    }

    public WorldInfoDefinition getGlobalWorldInfoDefinition() {
        return this.globalWorldInfo;
    }

    @ScriptMethodDocumentation(args="int", usage="dimension ID", notes="Used to add a dimension with this id using the default overworld WorldProvider.")
    public void addDimension(int id) {
        this.dimensionsToRegister.add(id);
    }

    public void registerDimensions() {
        for (int id : this.dimensionsToRegister) {
            if (DimensionManager.isDimensionRegistered((int)id)) continue;
            DimensionManager.registerDimension((int)id, (DimensionType)DimensionType.OVERWORLD);
        }
    }

    public void replaceWorldProviders() {
        for (Map.Entry<Integer, DimensionDefinition> set : this.dimensionDefinitions.entrySet()) {
            DimensionType worldProviderType = set.getValue().getWorldProviderType();
            if (worldProviderType == null || !DimensionManager.isDimensionRegistered((int)set.getKey())) continue;
            DimensionManager.unregisterDimension((int)set.getKey());
            DimensionManager.registerDimension((int)set.getKey(), (DimensionType)worldProviderType);
        }
    }

    private void loadDimensionMap() {
        for (DimensionType type : DimensionType.values()) {
            int[] dimensions = DimensionManager.getDimensions((DimensionType)type);
            for (int i = 0; i < dimensions.length; ++i) {
                this.dimensionMapCopy.put(dimensions[i], type);
            }
        }
    }

    public void printBiomes() {
        for (BiomePrinter printer : this.biomePrinters) {
            try {
                printer.print();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @ScriptMethodDocumentation(args="int, int, int, int, int, int", usage="dimension ID, height, width, spacing, startX, startZ", notes="Used to add a biome printer for the selected dimension. I suggest 500 height, 500 width, 10 spacing, 0 startX, 0 startZ for most cases. This can take a long time, or even run the game out of memory in extreme cases, if the size is set too high. Images are saved to config/dimensionalcontrol/output and overwrite eachother.")
    public void addBiomePrinter(int dimensionID, int height, int width, int spacing, int startX, int startZ) {
        this.biomePrinters.add(new BiomePrinter(dimensionID, height, width, spacing, startX, startZ, true));
    }

    @ScriptMethodDocumentation(args="int, int, int, int, int, int, boolean", usage="dimension ID, height, width, spacing, startX, startZ, overwrite", notes="Used to add a biome printer for the selected dimension. I suggest 500 height, 500 width, 10 spacing, 0 startX, 0 startZ for most cases. This can take a long time, or even run the game out of memory in extreme cases, if the size is set too high. Images are saved to config/dimensionalcontrol/output and overwrite eachother if overwrite is set to true.")
    public void addBiomePrinter(int dimensionID, int height, int width, int spacing, int startX, int startZ, boolean overwrite) {
        this.biomePrinters.add(new BiomePrinter(dimensionID, height, width, spacing, startX, startZ, overwrite));
    }

    public MainConfig getMainConfig() {
        return this.mainConfig;
    }

    public void addDimensionDefinition(DimensionDefinition definition, int id) {
        this.dimensionDefinitions.put(id, definition);
    }

    public DimensionDefinition getDimensionDefinition(int id) {
        return this.dimensionDefinitions.get(id);
    }

    public static void createNewInstance(String preset) {
        DimensionalControl.instance.getLog().info((Object)("Creating Configuration Manager with preset '" + preset + "'."));
        instance = new ConfigurationManager(preset);
        ConfigurationManager.getInstance().read(preset);
    }

    public static void cleanUp() {
        for (Integer n : ConfigurationManager.instance.dimensionsToRegister) {
            if (ConfigurationManager.instance.dimensionMapCopy.containsKey(n)) continue;
            DimensionManager.unregisterDimension((int)n);
        }
        for (Map.Entry entry : ConfigurationManager.instance.dimensionDefinitions.entrySet()) {
            DimensionType worldProviderType = ((DimensionDefinition)entry.getValue()).getWorldProviderType();
            if (worldProviderType == null || !DimensionManager.isDimensionRegistered((int)((Integer)entry.getKey()))) continue;
            DimensionManager.unregisterDimension((int)((Integer)entry.getKey()));
            DimensionManager.registerDimension((int)((Integer)entry.getKey()), (DimensionType)ConfigurationManager.instance.dimensionMapCopy.get(entry.getKey()));
        }
        instance = null;
    }

    private void read(String preset) {
        this.readMainConfig();
        if (this.mainConfig.shouldPrintDefaultConfigs()) {
            DimensionalControl.instance.getLog().info((Object)"Printing default configs.");
            DefaultConfigs.printDefaultConfigs();
            this.printDocumentation();
            ConfigurationManager.createNewInstance(preset);
        } else {
            this.printDocumentation();
            this.loadDimensionMap();
            this.readDimensions();
            this.registerDimensions();
            this.replaceWorldProviders();
        }
    }

    private void printDocumentation() {
        if (this.getMainConfig().shouldPrintDocumentation()) {
            DimensionalControl.instance.getLog().info((Object)"Printing documentation to config/dimensionalcontrol/documentation/");
            ScriptDocumentationHandler.printAnnotatedDocumentation((String)"com.bloodnbonesgaming.dimensionalcontrol");
            ScriptDocumentationHandler.copyDocumentationFolder(ConfigurationManager.class, (String)"./config/dimensionalcontrol/documentation/");
        }
    }

    private void readMainConfig() {
        IOHelper.loadMainConfig(this.mainConfig);
    }

    private void readDimensions() {
        IOHelper.loadDimensionsFile(this);
    }

    @ScriptMethodDocumentation(args="int, String", usage="dimension ID, script name", notes="Sets the dimension script for the provided dimensionID. The script will be searched for in config/dimensionalcontrol/dimensions/.")
    public void setScriptForDimension(int dimensionID, String definitionName) {
        DimensionDefinition definition = new DimensionDefinition();
        IOHelper.loadDimensionDefinition(definitionName, definition);
        if (definition != null) {
            this.dimensionDefinitions.put(dimensionID, definition);
        }
    }

    @ScriptMethodDocumentation(args="int", usage="dimension ID", notes="Sets the DimensionDefiniton object for the provided dimensionID and returns it, so functions can be called on it. The same functions that can be called in a dimension script, can be called on this object. Documentation can be found in documentation/dimensions/DimensionScript.txt")
    public DimensionDefinition setDimensionDefinition(int dimensionID) {
        DimensionDefinition definition = new DimensionDefinition();
        this.dimensionDefinitions.put(dimensionID, definition);
        return definition;
    }

    @ScriptMethodDocumentation(args="int, DimensionDefinition", usage="dimension ID, dimension definition", notes="Sets the DimensionDefiniton for provided dimensionID.")
    public DimensionDefinition setDimensionDefinition(int dimensionID, DimensionDefinition definition) {
        this.dimensionDefinitions.put(dimensionID, definition);
        return definition;
    }

    public static ConfigurationManager getInstance() {
        if (instance == null) {
            DimensionalControl.instance.getLog().debug((Object)"The ConfigurationManager is being called before it's been initialized!");
        }
        return instance;
    }
}

