/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.client.gui;

import com.bloodnbonesgaming.dimensionalcontrol.client.gui.element.GuiElementText;
import com.bloodnbonesgaming.dimensionalcontrol.client.gui.element.GuiElementTexture;
import com.bloodnbonesgaming.dimensionalcontrol.client.gui.element.GuiElementTextureAnimated;
import com.bloodnbonesgaming.dimensionalcontrol.client.gui.element.GuiElementTextureStretch;
import com.bloodnbonesgaming.dimensionalcontrol.client.gui.element.GuiElementTextureTile;
import com.bloodnbonesgaming.dimensionalcontrol.config.EnumGuiLocation;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/gui/LoadingScreen", classExplaination="Custom loading screen for all your loading needs. Anchor point options are \"Top_Left\", \"Top_Center\", \"Top_Right\", \"Left\", \"Center\", \"Right\", \"Bottom_Left\", \"Bottom_Center\", \"Bottom_Right\"")
public class GuiDownloadTerrainCustom
extends GuiScreen {
    private final List<Integer> toDimensions = new ArrayList<Integer>();
    private final List<Integer> fromDimensions = new ArrayList<Integer>();
    private final List<GuiElementText> textElements = new ArrayList<GuiElementText>();
    private final List<GuiElementTexture> textureElements = new ArrayList<GuiElementTexture>();
    private final List<GuiElementTextureAnimated> animatedTextureElements = new ArrayList<GuiElementTextureAnimated>();

    public GuiDownloadTerrainCustom() {
    }

    public GuiDownloadTerrainCustom(Integer toDimension, Integer fromDimension) {
        this.toDimensions.add(toDimension);
        this.fromDimensions.add(fromDimension);
    }

    public GuiDownloadTerrainCustom(int[] toDimension, Integer fromDimension) {
        for (int i = 0; i < toDimension.length; ++i) {
            this.toDimensions.add(toDimension[i]);
        }
        this.fromDimensions.add(fromDimension);
    }

    public GuiDownloadTerrainCustom(Integer toDimension, int[] fromDimension) {
        this.toDimensions.add(toDimension);
        for (int i = 0; i < fromDimension.length; ++i) {
            this.fromDimensions.add(fromDimension[i]);
        }
    }

    public GuiDownloadTerrainCustom(int[] toDimension, int[] fromDimension) {
        int i;
        for (i = 0; i < toDimension.length; ++i) {
            this.toDimensions.add(toDimension[i]);
        }
        for (i = 0; i < fromDimension.length; ++i) {
            this.fromDimensions.add(fromDimension[i]);
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        for (GuiElementTexture guiElementTexture : this.textureElements) {
            guiElementTexture.render(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
        for (GuiElementTextureAnimated guiElementTextureAnimated : this.animatedTextureElements) {
            guiElementTextureAnimated.render(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
        for (GuiElementText guiElementText : this.textElements) {
            guiElementText.render(this.field_146289_q, this.field_146294_l, this.field_146295_m);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_146281_b() {
        for (GuiElementTextureAnimated element : this.animatedTextureElements) {
            element.clean();
        }
        super.func_146281_b();
    }

    public boolean func_73868_f() {
        return false;
    }

    public List<Integer> getToDimensions() {
        return this.toDimensions;
    }

    public List<Integer> getFromDimensions() {
        return this.fromDimensions;
    }

    @ScriptMethodDocumentation(args="String, String", usage="anchor point, texture location", notes="Adds a tiled texture. Documentation can be found in documentation/gui/guiElements/Tiled_Texture.txt")
    public GuiElementTextureTile addTiledTexture(String location, String texture) throws Exception {
        EnumGuiLocation eLocation = EnumGuiLocation.valueOf(location.toUpperCase());
        if (eLocation != null) {
            GuiElementTextureTile element = new GuiElementTextureTile(eLocation, new ResourceLocation(texture));
            this.textureElements.add(element);
            return element;
        }
        throw new Exception(location + " is not a valid gui location!");
    }

    @ScriptMethodDocumentation(args="String, String", usage="anchor point, texture location", notes="Adds a stretched texture. Documentation can be found in documentation/gui/guiElements/Stretched_Texture.txt")
    public GuiElementTextureStretch addStretchedTexture(String location, String texture) throws Exception {
        EnumGuiLocation eLocation = EnumGuiLocation.valueOf(location.toUpperCase());
        if (eLocation != null) {
            GuiElementTextureStretch element = new GuiElementTextureStretch(eLocation, new ResourceLocation(texture));
            this.textureElements.add(element);
            return element;
        }
        throw new Exception(location + " is not a valid gui location!");
    }

    @ScriptMethodDocumentation(args="String, String", usage="anchor point, texture location", notes="Adds an animated texture. Documentation can be found in documentation/gui/guiElements/Animated_Texture.txt")
    public GuiElementTextureAnimated addAnimatedTexture(String location, String texture) throws Exception {
        EnumGuiLocation eLocation = EnumGuiLocation.valueOf(location.toUpperCase());
        if (eLocation != null) {
            GuiElementTextureAnimated element = new GuiElementTextureAnimated(eLocation, new ResourceLocation(texture));
            this.animatedTextureElements.add(element);
            return element;
        }
        throw new Exception(location + " is not a valid gui location!");
    }

    @ScriptMethodDocumentation(args="String, String", usage="anchor point, text", notes="Adds a text string. Documentation can be found in documentation/gui/guiElements/Text.txt")
    public GuiElementText addText(String location, String text) throws Exception {
        EnumGuiLocation eLocation = EnumGuiLocation.valueOf(location.toUpperCase());
        if (eLocation != null) {
            GuiElementText element = new GuiElementText(eLocation, text);
            this.textElements.add(element);
            return element;
        }
        throw new Exception(location + " is not a valid gui location!");
    }
}

