/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.client.render.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.m4thg33k.tombmanygraves.ModConfigs;
import com.m4thg33k.tombmanygraves.api.state.TMGStateProps;
import com.m4thg33k.tombmanygraves.blocks.BlockGrave;
import com.m4thg33k.tombmanygraves.blocks.ModBlocks;
import com.m4thg33k.tombmanygraves.client.render.models.ModelHelper;
import com.m4thg33k.tombmanygraves.tiles.TileGrave;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;

public class AdaptiveGraveModel
implements IBakedModel {
    private final IBakedModel standard;
    private final IModel retexturableModel;
    private static final IBlockState dirtState = Blocks.field_150346_d.func_176223_P();
    private final Map<String, IBakedModel> model_cache = Maps.newHashMap();

    public AdaptiveGraveModel(IBakedModel standard, IModel retexturableModel) {
        this.standard = standard;
        this.retexturableModel = retexturableModel;
    }

    protected IBakedModel getActualModel(String texture) {
        IBakedModel bakedModel = this.standard;
        if (texture != null) {
            if (this.model_cache.containsKey(texture)) {
                bakedModel = this.model_cache.get(texture);
            } else if (this.retexturableModel != null) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.put((Object)"bottom", (Object)texture);
                builder.put((Object)"top", (Object)texture);
                builder.put((Object)"side", (Object)texture);
                IModel retexturedModel = this.retexturableModel.retexture(builder.build());
                bakedModel = retexturedModel.bake((IModelState)TRSRTransformation.identity(), Attributes.DEFAULT_BAKED_FORMAT, ModelLoader.defaultTextureGetter());
                this.model_cache.put(texture, bakedModel);
            }
        }
        return bakedModel;
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state == null) {
            return this.standard.func_188616_a(null, side, rand);
        }
        if (state.func_177230_c() != ModBlocks.blockGrave) {
            return this.standard.func_188616_a(state, side, rand);
        }
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        IBlockState heldState = (IBlockState)((IExtendedBlockState)state).getValue(TMGStateProps.HELD_STATE);
        IBlockAccess heldWorld = (IBlockAccess)((IExtendedBlockState)state).getValue(TMGStateProps.HELD_WORLD);
        BlockPos heldPos = (BlockPos)((IExtendedBlockState)state).getValue(TMGStateProps.HELD_POS);
        if (heldWorld == null || heldPos == null) {
            return ImmutableList.of();
        }
        if (heldState == null || heldState.func_177230_c() instanceof BlockGrave) {
            return ImmutableList.of();
        }
        if (ModConfigs.FORCE_DIRT_RENDER || heldState.func_177230_c() == Blocks.field_150350_a || !heldState.func_177230_c().canRenderInLayer(heldState, layer) || heldState.func_177230_c().hasTileEntity(heldState)) {
            return this.getActualModel(ModelHelper.getTextureFromBlockstate(dirtState).func_94215_i()).func_188616_a(dirtState, side, rand);
        }
        IBlockState actualState = heldState.func_177230_c().func_176221_a(heldState, (IBlockAccess)new FakeBlockAccess(heldWorld), heldPos);
        return this.getActualModel(ModelHelper.getTextureFromBlockstate(actualState).func_94215_i()).func_188616_a(actualState, side, rand);
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b("tombmanygraves:blocks/grave_block");
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    private static class FakeBlockAccess
    implements IBlockAccess {
        private final IBlockAccess compose;

        private FakeBlockAccess(IBlockAccess compose) {
            this.compose = compose;
        }

        @ParametersAreNonnullByDefault
        @Nullable
        public TileEntity func_175625_s(BlockPos pos) {
            return this.compose.func_175625_s(pos);
        }

        @ParametersAreNonnullByDefault
        public int func_175626_b(BlockPos pos, int lightValue) {
            return 0xF000F0;
        }

        @ParametersAreNonnullByDefault
        @Nonnull
        public IBlockState func_180495_p(BlockPos pos) {
            Object state = this.compose.func_180495_p(pos);
            if (state.func_177230_c() instanceof BlockGrave) {
                TileEntity tile = this.compose.func_175625_s(pos);
                state = tile != null && tile instanceof TileGrave ? ((TileGrave)tile).getCamoState() : null;
            }
            return state == null ? Blocks.field_150350_a.func_176223_P() : state;
        }

        @ParametersAreNonnullByDefault
        public boolean func_175623_d(BlockPos pos) {
            return this.compose.func_175623_d(pos);
        }

        @Nonnull
        @ParametersAreNonnullByDefault
        public Biome func_180494_b(BlockPos pos) {
            return this.compose.func_180494_b(pos);
        }

        @ParametersAreNonnullByDefault
        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return this.compose.func_175627_a(pos, direction);
        }

        @Nonnull
        public WorldType func_175624_G() {
            return this.compose.func_175624_G();
        }

        @ParametersAreNonnullByDefault
        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            return this.compose.isSideSolid(pos, side, _default);
        }
    }
}

