/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import info.openmods.calc.Frame;
import info.openmods.calc.types.multi.MetaObject;
import info.openmods.calc.types.multi.TypedValue;
import info.openmods.calc.utils.OptionalInt;
import info.openmods.calc.utils.reflection.TypeVariableHolder;
import info.openmods.calc.utils.reflection.TypeVariableHolderFiller;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class MetaObjectInfo {
    public static final Map<String, ISlotAccess> singleSlots;
    public static final Map<String, ISlotAccessProvider> mappedSlots;

    private static MetaObject.SlotAdapter<MetaObject.Slot> createAdapterInstance(Class<?> slotCls, MetaObject.SlotField annotation) {
        Class<? extends MetaObject.SlotAdapter<? extends MetaObject.Slot>> adapterCls = annotation.adapter();
        Class slotAdapterTarget = TypeToken.of(adapterCls).resolveType(TypeVariableHolders.SlotAdapterVars.T).getRawType();
        Preconditions.checkState((slotAdapterTarget == slotCls ? 1 : 0) != 0, (String)"Invalid slot adapter type: expected %s, got %s", slotCls, (Object)slotAdapterTarget);
        try {
            return adapterCls.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        TypeVariableHolderFiller.instance.initialize(TypeVariableHolders.class);
        ImmutableMap.Builder singleSlotsBuilder = ImmutableMap.builder();
        ImmutableMap.Builder mappedSlotsBuilder = ImmutableMap.builder();
        HashMap singleSlotBuilderMethods = Maps.newHashMap();
        HashMap mappedSlotBuilderMethods = Maps.newHashMap();
        for (Method method : MetaObject.Builder.class.getDeclaredMethods()) {
            Class<?> slotCls;
            if (!method.getName().equals("set")) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == 1) {
                slotCls = parameterTypes[0];
                Preconditions.checkState((boolean)MetaObject.Slot.class.isAssignableFrom(slotCls), (String)"Invalid builder method: %s", (Object)method);
                singleSlotBuilderMethods.put(slotCls, method);
                continue;
            }
            if (parameterTypes.length == 2) {
                Preconditions.checkState((parameterTypes[0] == String.class ? 1 : 0) != 0, (String)"Invalid builder method: %s", (Object)method);
                slotCls = parameterTypes[1];
                Preconditions.checkState((boolean)MetaObject.Slot.class.isAssignableFrom(slotCls), (String)"Invalid builder method: %s", (Object)method);
                mappedSlotBuilderMethods.put(slotCls, method);
                continue;
            }
            throw new IllegalArgumentException("Invalid builder method: " + method);
        }
        for (AccessibleObject accessibleObject : MetaObject.class.getDeclaredFields()) {
            String lcSlotName;
            String slotName;
            MetaObject.SlotField annotation = ((Field)accessibleObject).getAnnotation(MetaObject.SlotField.class);
            if (annotation == null) continue;
            String fieldName = ((Field)accessibleObject).getName();
            if (fieldName.startsWith("slots")) {
                slotName = fieldName.substring("slots".length());
                lcSlotName = slotName.toLowerCase(Locale.ROOT);
                TypeToken mapType = TypeToken.of((Type)((Field)accessibleObject).getGenericType());
                Class keyCls = mapType.resolveType(TypeVariableHolders.MapVars.K).getRawType();
                Preconditions.checkState((keyCls == String.class ? 1 : 0) != 0, (String)"Invalid slot field: %s", (Object)accessibleObject);
                Class slotCls = mapType.resolveType(TypeVariableHolders.MapVars.V).getRawType();
                MetaObject.SlotAdapter<MetaObject.Slot> adapter = MetaObjectInfo.createAdapterInstance(slotCls, annotation);
                Method builderMethod = (Method)mappedSlotBuilderMethods.get(slotCls);
                Preconditions.checkState((builderMethod != null ? 1 : 0) != 0, (String)"Missing builder method for %s", (Object)lcSlotName);
                mappedSlotsBuilder.put((Object)lcSlotName, (Object)new MappedSlotAccessFactory((Field)accessibleObject, builderMethod, lcSlotName, adapter));
                continue;
            }
            if (fieldName.startsWith("slot")) {
                slotName = fieldName.substring("slot".length());
                lcSlotName = slotName.toLowerCase(Locale.ROOT);
                Class<?> slotCls = ((Field)accessibleObject).getType();
                MetaObject.SlotAdapter<MetaObject.Slot> adapter = MetaObjectInfo.createAdapterInstance(slotCls, annotation);
                Method builderMethod = (Method)singleSlotBuilderMethods.get(slotCls);
                Preconditions.checkState((builderMethod != null ? 1 : 0) != 0, (String)"Missing builder method for %s", (Object)lcSlotName);
                singleSlotsBuilder.put((Object)lcSlotName, (Object)new SingleSlotAccess((Field)accessibleObject, builderMethod, lcSlotName, adapter));
                continue;
            }
            throw new AssertionError((Object)("Invalid slot name: " + fieldName));
        }
        singleSlots = singleSlotsBuilder.build();
        mappedSlots = mappedSlotsBuilder.build();
        Sets.SetView commonSlotNames = Sets.intersection(singleSlots.keySet(), mappedSlots.keySet());
        Preconditions.checkState((boolean)commonSlotNames.isEmpty(), (String)"Duplicate slots: %s", (Object)commonSlotNames);
    }

    private static class MappedSlotAccessFactory
    implements ISlotAccessProvider {
        public final String name;
        public final MetaObject.SlotAdapter<MetaObject.Slot> adapter;
        private final Field mapField;
        private final Method builderMethod;

        public MappedSlotAccessFactory(Field mapField, Method builderMethod, String name, MetaObject.SlotAdapter<MetaObject.Slot> adapter) {
            this.name = name;
            this.adapter = adapter;
            this.mapField = mapField;
            this.builderMethod = builderMethod;
        }

        @Override
        public ISlotAccess create(String key) {
            return new Access(key);
        }

        public class Access
        implements ISlotAccess {
            private final String name;
            private final String key;

            private Map<String, ? extends MetaObject.Slot> getMap(MetaObject mo) throws IllegalAccessException {
                return (Map)MappedSlotAccessFactory.this.mapField.get(mo);
            }

            public Access(String key) {
                this.key = key;
                this.name = MappedSlotAccessFactory.this.name + ":" + key;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public boolean checkIsPresent(MetaObject mo) {
                try {
                    return this.getMap(mo).containsKey(this.key);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void call(MetaObject.Slot slot, Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
                MappedSlotAccessFactory.this.adapter.call(slot, frame, argumentsCount, returnsCount);
            }

            @Override
            public MetaObject.Slot wrap(TypedValue slotValue) {
                return MappedSlotAccessFactory.this.adapter.wrap(slotValue);
            }

            @Override
            public MetaObject.Slot get(MetaObject mo) {
                try {
                    return this.getMap(mo).get(this.key);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void set(MetaObject.Builder builder, MetaObject.Slot slot) {
                try {
                    MappedSlotAccessFactory.this.builderMethod.invoke((Object)builder, this.key, slot);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static class SingleSlotAccess
    implements ISlotAccess {
        private final String name;
        private final MetaObject.SlotAdapter<MetaObject.Slot> adapter;
        private final Field field;
        private final Method builderMethod;

        public SingleSlotAccess(Field field, Method builderMethod, String name, MetaObject.SlotAdapter<MetaObject.Slot> adapter) {
            this.field = field;
            this.name = name;
            this.adapter = adapter;
            this.builderMethod = builderMethod;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean checkIsPresent(MetaObject mo) {
            try {
                return this.field.get(mo) != null;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void call(MetaObject.Slot slot, Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            this.adapter.call(slot, frame, argumentsCount, returnsCount);
        }

        @Override
        public MetaObject.Slot wrap(TypedValue slotValue) {
            return this.adapter.wrap(slotValue);
        }

        @Override
        public MetaObject.Slot get(MetaObject mo) {
            try {
                return (MetaObject.Slot)this.field.get(mo);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void set(MetaObject.Builder builder, MetaObject.Slot slot) {
            try {
                this.builderMethod.invoke((Object)builder, slot);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface ISlotAccessProvider {
        public ISlotAccess create(String var1);
    }

    public static interface ISlotAccess {
        public String name();

        public boolean checkIsPresent(MetaObject var1);

        public void call(MetaObject.Slot var1, Frame<TypedValue> var2, OptionalInt var3, OptionalInt var4);

        public MetaObject.Slot get(MetaObject var1);

        public void set(MetaObject.Builder var1, MetaObject.Slot var2);

        public MetaObject.Slot wrap(TypedValue var1);
    }

    private static class TypeVariableHolders {
        private TypeVariableHolders() {
        }

        @TypeVariableHolder(value=Map.class)
        public static class MapVars {
            public static TypeVariable<?> K;
            public static TypeVariable<?> V;
        }

        @TypeVariableHolder(value=MetaObject.SlotAdapter.class)
        public static class SlotAdapterVars {
            public static TypeVariable<?> T;
        }
    }
}

