/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.rule.match;

import com.codetaylor.mc.dropt.modules.dropt.rule.data.RuleMatch;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.BiomeMatcher;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.BlockMatcher;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.DimensionMatcher;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.DropMatcher;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.HarvesterMatcher;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.HeldItemCache;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class RuleMatcher {
    private final BlockMatcher blockMatcher;
    private final DropMatcher dropMatcher;
    private final HarvesterMatcher harvesterMatcher;
    private final BiomeMatcher biomeMatcher;
    private final DimensionMatcher dimensionMatcher;
    private final EntityPlayer harvester;
    private final Biome biome;
    private final int dimension;
    private final int posY;
    private final IBlockState blockState;
    private final List<ItemStack> drops;
    private final boolean isExplosion;

    public RuleMatcher(World world, EntityPlayer harvester, BlockPos pos, IBlockState blockState, List<ItemStack> drops, boolean isExplosion, BlockMatcher blockMatcher, DropMatcher dropMatcher, HarvesterMatcher harvesterMatcher, BiomeMatcher biomeMatcher, DimensionMatcher dimensionMatcher) {
        this.blockMatcher = blockMatcher;
        this.dropMatcher = dropMatcher;
        this.harvesterMatcher = harvesterMatcher;
        this.biomeMatcher = biomeMatcher;
        this.dimensionMatcher = dimensionMatcher;
        this.harvester = harvester;
        this.biome = world.func_180494_b(pos);
        this.dimension = world.field_73011_w.getDimension();
        this.posY = pos.func_177956_o();
        this.blockState = blockState;
        this.drops = drops;
        this.isExplosion = isExplosion;
    }

    public boolean matches(RuleMatch ruleMatch, HeldItemCache heldItemCache, DebugFileWrapper logFile, boolean debug) {
        boolean result;
        if (debug) {
            logFile.debug("");
        }
        boolean bl = result = this.matchVerticalRange(ruleMatch, this.posY, logFile, debug) && this.blockMatcher.matches(ruleMatch.blocks, this.blockState, logFile, debug) && this.dropMatcher.matches(ruleMatch.drops, logFile, debug, this.drops) && this.harvesterMatcher.matches(ruleMatch.harvester, heldItemCache, this.harvester, this.blockState, this.isExplosion, logFile, debug) && this.biomeMatcher.matches(ruleMatch.biomes, this.biome, logFile, debug) && this.dimensionMatcher.matches(ruleMatch.dimensions, this.dimension, logFile, debug);
        if (debug) {
            if (result) {
                logFile.debug("[OK] Rule matched");
            } else {
                logFile.debug("[!!] Rule not matched");
            }
        }
        return result;
    }

    private boolean matchVerticalRange(RuleMatch ruleMatch, int posY, DebugFileWrapper logFile, boolean debug) {
        boolean result;
        boolean bl = result = posY <= ruleMatch.verticalRange.max && posY >= ruleMatch.verticalRange.min;
        if (debug) {
            if (!result) {
                logFile.debug(String.format("[MATCH] [!!] Vertical position out of bounds: %d <= %d <= %d", ruleMatch.verticalRange.min, posY, ruleMatch.verticalRange.max));
            } else {
                logFile.debug(String.format("[MATCH] [OK] Vertical position within bounds: %d <= %d <= %d", ruleMatch.verticalRange.min, posY, ruleMatch.verticalRange.max));
            }
        }
        return result;
    }
}

