/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.compat.crafttweaker;

import com.codetaylor.mc.athenaeum.integration.crafttweaker.mtlib.helpers.CTInputHelper;
import com.codetaylor.mc.dropt.api.DroptAPI;
import com.codetaylor.mc.dropt.modules.dropt.compat.crafttweaker.ZenDrop;
import com.codetaylor.mc.dropt.modules.dropt.compat.crafttweaker.ZenHarvester;
import com.codetaylor.mc.dropt.modules.dropt.compat.crafttweaker.ZenRange;
import com.codetaylor.mc.dropt.modules.dropt.compat.crafttweaker.ZenRule;
import com.codetaylor.mc.dropt.modules.dropt.compat.crafttweaker.ZenRuleList;
import com.codetaylor.mc.dropt.modules.dropt.compat.crafttweaker.ZenWeight;
import com.codetaylor.mc.dropt.modules.dropt.compat.crafttweaker.export.ZenDocClass;
import com.codetaylor.mc.dropt.modules.dropt.compat.crafttweaker.export.ZenDocMethod;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.dropt.Dropt", description={"This class acts as an entry point to the Dropt API.", "Each method returns either a ready-to-configure object or a pre-configured object using the given parameters."})
@ZenClass(value="mods.dropt.Dropt")
public class ZenDropt {
    public static final Map<String, ZenRuleList> LISTS = new HashMap<String, ZenRuleList>();

    @ZenDocMethod(order=1, description={"Returns a new, ready-to-configure list object.", "Subsequent calls with the same name will return the same list object.", "@see /json/syntax/#irulelist"}, args={"name"})
    @ZenMethod
    public static ZenRuleList list(String name) {
        ZenRuleList list = LISTS.get(name);
        if (list == null) {
            list = new ZenRuleList(new ResourceLocation("crafttweaker", name));
            LISTS.put(name, list);
        }
        return list;
    }

    @ZenDocMethod(order=2, description={"Returns a new, ready-to-configure Rule object.", "@see /json/syntax/#irule"})
    @ZenMethod
    public static ZenRule rule() {
        return new ZenRule();
    }

    @ZenDocMethod(order=3, description={"Returns a new, ready-to-configure Harvester object.", "@see /json/syntax/#irulematchharvester"})
    @ZenMethod
    public static ZenHarvester harvester() {
        return new ZenHarvester();
    }

    @ZenDocMethod(order=4, description={"Returns a new, ready-to-configure Drop object.", "@see /json/syntax/#iruledrop"})
    @ZenMethod
    public static ZenDrop drop() {
        return new ZenDrop();
    }

    @ZenDocMethod(order=5, description={"Returns a range object with a fixed value.", "@see /json/syntax/#irangeint"}, args={"fixed"})
    @ZenMethod
    public static ZenRange range(int fixed) {
        return new ZenRange(DroptAPI.range(fixed));
    }

    @ZenDocMethod(order=6, description={"Returns a range object with a minimum and maximum value.", "The minimum and maximum values are inclusive.", "@see /json/syntax/#irangeint"}, args={"min", "max"})
    @ZenMethod
    public static ZenRange range(int min, int max) {
        return new ZenRange(DroptAPI.range(min, max));
    }

    @ZenDocMethod(order=7, description={"Returns a range object with the given minimum, maximum, and fortune modifier value.", "The minimum and maximum values are inclusive.", "@see /json/syntax/#irandomfortuneint"}, args={"min", "max", "fortuneModifier"})
    @ZenMethod
    public static ZenRange range(int min, int max, int fortuneModifier) {
        return new ZenRange(DroptAPI.range(min, max, fortuneModifier));
    }

    @ZenDocMethod(order=8, description={"Returns a weight object with the given weight.", "@see /json/syntax/#iruledropselectorweight"}, args={"weight"})
    @ZenMethod
    public static ZenWeight weight(int weight) {
        return new ZenWeight(DroptAPI.weight(weight));
    }

    @ZenDocMethod(order=9, description={"Returns a weight object with the given weight and fortune modifier.", "@see /json/syntax/#iruledropselectorweight"}, args={"weight", "fortuneModifier"})
    @ZenMethod
    public static ZenWeight weight(int weight, int fortuneModifier) {
        return new ZenWeight(DroptAPI.weight(weight, fortuneModifier));
    }

    static String[] getItemStrings(IItemStack[] items) {
        ItemStack[] itemStacks = CTInputHelper.toStacks((IItemStack[])items);
        String[] itemStrings = new String[itemStacks.length];
        for (int i = 0; i < itemStacks.length; ++i) {
            itemStrings[i] = DroptAPI.itemString(itemStacks[i]);
        }
        return itemStrings;
    }

    static String[] getItemStrings(IIngredient[] items) {
        ArrayList itemStacks = new ArrayList();
        for (int i = 0; i < items.length; ++i) {
            CTInputHelper.getMatchingStacks((IIngredient)items[i], itemStacks);
        }
        String[] itemStrings = new String[itemStacks.size()];
        for (int i = 0; i < itemStacks.size(); ++i) {
            itemStrings[i] = DroptAPI.itemString((ItemStack)itemStacks.get(i));
        }
        return itemStrings;
    }
}

