/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.api;

import com.codetaylor.mc.dropt.api.api.IDroptDropBuilder;
import com.codetaylor.mc.dropt.api.api.IDroptHarvesterRuleBuilder;
import com.codetaylor.mc.dropt.api.api.IDroptRuleBuilder;
import com.codetaylor.mc.dropt.api.api.IRuleRegistrationHandler;
import com.codetaylor.mc.dropt.api.api.RandomFortuneInt;
import com.codetaylor.mc.dropt.api.api.RuleDropSelectorWeight;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public final class DroptAPI {
    private static final Supplier<String> SUPPLIER_MOD_ID = null;
    private static final Supplier<IDroptRuleBuilder> SUPPLIER_RULE_BUILDER = null;
    private static final Supplier<IDroptHarvesterRuleBuilder> SUPPLIER_HARVESTER_RULE_BUILDER = null;
    private static final Supplier<IDroptDropBuilder> SUPPLIER_DROP_BUILDER = null;
    private static final IRuleRegistrationHandler CONSUMER_RULE = null;

    public static String modId() {
        return SUPPLIER_MOD_ID.get();
    }

    public static void registerRuleList(ResourceLocation id, int priority, List<IDroptRuleBuilder> builders) {
        CONSUMER_RULE.register(id, priority, builders);
    }

    public static IDroptRuleBuilder rule() {
        return SUPPLIER_RULE_BUILDER.get();
    }

    public static IDroptHarvesterRuleBuilder harvester() {
        return SUPPLIER_HARVESTER_RULE_BUILDER.get();
    }

    public static IDroptDropBuilder drop() {
        return SUPPLIER_DROP_BUILDER.get();
    }

    public static RandomFortuneInt range(int fixed) {
        RandomFortuneInt result = new RandomFortuneInt();
        result.fixed = fixed;
        return result;
    }

    public static RandomFortuneInt range(int min, int max) {
        RandomFortuneInt result = new RandomFortuneInt();
        result.min = min;
        result.max = max;
        return result;
    }

    public static RandomFortuneInt range(int min, int max, int fortuneModifier) {
        RandomFortuneInt result = new RandomFortuneInt();
        result.min = min;
        result.max = max;
        result.fortuneModifier = fortuneModifier;
        return result;
    }

    public static RuleDropSelectorWeight weight(int weight) {
        RuleDropSelectorWeight result = new RuleDropSelectorWeight();
        result.value = weight;
        return result;
    }

    public static RuleDropSelectorWeight weight(int weight, int fortuneModifier) {
        RuleDropSelectorWeight result = new RuleDropSelectorWeight();
        result.value = weight;
        result.fortuneModifier = fortuneModifier;
        return result;
    }

    public static String itemString(String domain, String path) {
        return DroptAPI.itemString(domain, path, 0, null);
    }

    public static String itemString(String domain, String path, int meta) {
        return DroptAPI.itemString(domain, path, meta, null);
    }

    public static String itemString(String domain, String path, int meta, @Nullable NBTTagCompound tag) {
        return domain + ":" + path + ":" + (meta == Short.MAX_VALUE ? "*" : Integer.valueOf(meta)) + (tag != null ? "#" + tag.toString() : "");
    }

    public static String itemString(ItemStack itemStack) {
        ResourceLocation registryName = itemStack.func_77973_b().getRegistryName();
        return DroptAPI.itemString(registryName.func_110624_b(), registryName.func_110623_a(), itemStack.func_77960_j(), itemStack.func_77978_p());
    }
}

