/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.mms;

import me.modmuss50.mms.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.Display;

@Mod(modid="mainmenuscale", name="Main Menu Scale", clientSideOnly=true, dependencies="required-after:reborncore", acceptedMinecraftVersions="[1.12.2]")
public class MainMenuScale {
    private boolean isMenuOpen = false;
    private int guiScale = -1;
    private int lastHeight = 0;

    @Mod.EventHandler
    public void init(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void initGuiPre(GuiScreenEvent.InitGuiEvent.Pre event) {
        if (event.getGui() instanceof GuiMainMenu || event.getGui().getClass().getName().equals("lumien.custommainmenu.gui.GuiCustom")) {
            this.openMainMenu(event.getGui());
        } else {
            this.closeMainMenu();
        }
    }

    public void openMainMenu(GuiScreen gui) {
        int height = Display.getHeight();
        if (this.isMenuOpen && this.lastHeight == height) {
            return;
        }
        this.lastHeight = height;
        if (!this.isMenuOpen) {
            this.guiScale = Minecraft.func_71410_x().field_71474_y.field_74335_Z;
        }
        this.isMenuOpen = true;
        int scale = Config.GUI_SCALE;
        if (Config.HIGH_RES_HEIGHT != -1 && height >= Config.HIGH_RES_HEIGHT) {
            scale = Config.HIGH_RES_SCALE;
        }
        Minecraft.func_71410_x().field_71474_y.field_74335_Z = scale;
        this.updateRes();
    }

    public void closeMainMenu() {
        if (!this.isMenuOpen) {
            this.lastHeight = -1;
            return;
        }
        this.isMenuOpen = false;
        Minecraft.func_71410_x().field_71474_y.field_74335_Z = this.guiScale;
        this.updateRes();
    }

    public void updateRes() {
        Minecraft minecraft = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(minecraft);
        int i = scaledresolution.func_78326_a();
        int j = scaledresolution.func_78328_b();
        minecraft.field_71462_r.func_146280_a(minecraft, i, j);
    }
}

