/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.registrysystem.config;

import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigEntry {
    private String category;
    private String propertyName;
    private boolean isArray;
    private Property.Type type;
    private String value;
    private String comment;
    private boolean guiChangeable;

    public ConfigEntry(String propertyName, String value) {
        this("General", propertyName, Property.Type.STRING, value);
    }

    public ConfigEntry(String category, String propertyName, Property.Type type, String value) {
        this(category, propertyName, type, value, "");
    }

    public ConfigEntry(String category, String propertyName, Property.Type type, String value, String comment) {
        this(category, propertyName, type, value, comment, true);
    }

    public ConfigEntry(String category, String propertyName, Property.Type type, String value, String comment, boolean guiChangeable) {
        this(category, propertyName, type, value, comment, guiChangeable, false);
    }

    public ConfigEntry(String category, String propertyName, Property.Type type, String value, String comment, boolean guiChangeable, boolean isArray) {
        this.setCategory(category);
        this.setPropertyName(propertyName);
        this.setType(type);
        this.setValue(value);
        this.setComment(comment);
        this.setGuiChangeable(guiChangeable);
        this.setArray(isArray);
    }

    public void saveProperty(Configuration configuration) {
        switch (this.getType()) {
            case INTEGER: {
                Property property = configuration.get(this.getCategory(), this.getPropertyName(), Integer.parseInt(this.getValue()), this.getComment());
                this.value = Integer.toString(property.getInt());
                break;
            }
            case BOOLEAN: {
                Property property = configuration.get(this.getCategory(), this.getPropertyName(), Boolean.parseBoolean(this.getValue()), this.getComment());
                this.value = Boolean.toString(property.getBoolean());
                break;
            }
            case DOUBLE: {
                Property property = configuration.get(this.getCategory(), this.getPropertyName(), Double.parseDouble(this.getValue()), this.getComment());
                this.value = Double.toString(property.getDouble());
                break;
            }
            default: {
                if (!this.isArray) {
                    this.value = configuration.get(this.getCategory(), this.getPropertyName(), this.getValue(), this.getComment()).getString();
                    break;
                }
                String[] values = this.value.split(",");
                this.value = String.join((CharSequence)",", configuration.get(this.getCategory(), this.getPropertyName(), values, this.getComment()).getStringList());
            }
        }
    }

    public int getInt(int defaultValue) {
        try {
            return Integer.parseInt(this.getValue());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(boolean defaultValue) {
        if (this.getType() == Property.Type.BOOLEAN) {
            return Boolean.parseBoolean(this.getValue());
        }
        return defaultValue;
    }

    public double getDouble(double defaultValue) {
        try {
            return Double.parseDouble(this.getValue());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String getString() {
        return this.getValue();
    }

    public String[] getStringArray() {
        String[] stringArray = this.isArray ? this.getString().split(",") : new String[]{this.getString()};
        return stringArray;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isGuiChangeable() {
        return this.guiChangeable;
    }

    public void setGuiChangeable(boolean guiChangeable) {
        this.guiChangeable = guiChangeable;
    }

    public Property.Type getType() {
        return this.type;
    }

    public void setType(Property.Type type) {
        this.type = type;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setArray(boolean array) {
        this.isArray = array;
    }
}

