/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.materialsystem.blocks;

import com.google.common.collect.Maps;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.GeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.IGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.ModelType;
import com.teamacronymcoders.base.materialsystem.materialparts.MaterialPart;
import com.teamacronymcoders.base.materialsystem.partdata.DataPartParsers;
import com.teamacronymcoders.base.materialsystem.partdata.MaterialPartData;
import com.teamacronymcoders.base.materialsystem.parts.Part;
import com.teamacronymcoders.base.subblocksystem.blocks.SubBlockBase;
import com.teamacronymcoders.base.util.files.templates.TemplateFile;
import com.teamacronymcoders.base.util.files.templates.TemplateManager;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SubBlockPart
extends SubBlockBase {
    private MaterialPart materialPart;
    private CreativeTabs creativeTabs;
    private float hardness = 5.0f;
    private int resistance = 30;
    private int harvestLevel = 1;
    private String harvestTool = "pickaxe";

    public SubBlockPart(MaterialPart materialPart, CreativeTabs creativeTab) {
        super(materialPart.getUnlocalizedName());
        this.materialPart = materialPart;
        MaterialPartData data = this.materialPart.getData();
        this.hardness = data.getValue("hardness", Float.valueOf(this.hardness), DataPartParsers::getFloat).floatValue();
        this.resistance = data.getValue("resistance", this.resistance, DataPartParsers::getInt);
        this.harvestLevel = data.getValue("harvestLevel", this.harvestLevel, DataPartParsers::getInt);
        this.harvestTool = data.getValue("harvestTool", this.harvestTool, DataPartParsers::getString);
        this.creativeTabs = creativeTab;
    }

    public void setHardness(float hardness) {
        this.hardness = hardness;
    }

    public void setResistance(int resistance) {
        this.resistance = resistance;
    }

    public void setHarvestLevel(int harvestLevel) {
        this.harvestLevel = harvestLevel;
    }

    public void setHarvestTool(String harvestTool) {
        this.harvestTool = harvestTool;
    }

    @Override
    public String getLocalizedName() {
        return this.materialPart.getLocalizedName();
    }

    @Override
    public String getUnLocalizedName() {
        return this.materialPart.getUnlocalizedName();
    }

    @Override
    public int getColor() {
        return this.materialPart.getColor();
    }

    @Override
    public float getHardness() {
        return this.hardness;
    }

    @Override
    public int getResistance() {
        return this.resistance;
    }

    @Override
    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    @Override
    public String getHarvestTool() {
        return this.harvestTool;
    }

    @Override
    public String getOreDict() {
        return this.materialPart.getOreDictString();
    }

    @Override
    @Nullable
    public CreativeTabs getCreativeTab() {
        return this.creativeTabs;
    }

    @Override
    public ResourceLocation getTextureLocation() {
        ResourceLocation location = this.materialPart.getTextureLocation();
        return new ResourceLocation(location.func_110624_b(), this.getModelPrefix() + this.getUnLocalizedName());
    }

    @Override
    public IGeneratedModel getGeneratedModel() {
        TemplateFile templateFile = TemplateManager.getTemplateFile("colored_block");
        HashMap replacements = Maps.newHashMap();
        Part part = this.materialPart.getPart();
        replacements.put("texture", String.format("%s:blocks/%s", part.getOwnerId(), part.getShortUnlocalizedName()));
        templateFile.replaceContents(replacements);
        return new GeneratedModel(this.getModelPrefix() + this.getUnLocalizedName(), ModelType.BLOCKSTATE, templateFile.getFileContents());
    }

    @Override
    protected String getModelPrefix() {
        return "materials/";
    }

    public MaterialPart getMaterialPart() {
        return this.materialPart;
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return true;
    }

    @Override
    public boolean isTopSolid() {
        return true;
    }

    @Override
    public BlockFaceShape getBlockFaceShape() {
        return BlockFaceShape.SOLID;
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return Block.field_185505_j;
    }

    @Override
    public boolean isFullCube() {
        return true;
    }

    @Override
    public boolean isOpaqueCube() {
        return true;
    }

    @Override
    public boolean isPassable() {
        return false;
    }

    @Override
    public boolean isFullBlock() {
        return true;
    }

    @Override
    public int getLightOpacity() {
        return 255;
    }

    @Override
    public boolean canSilkHarvest() {
        return true;
    }

    @Override
    public boolean canPlaceBlockAt(World world, @Nonnull BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, EntityPlayer player) {
        return false;
    }
}

