/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.util;

import java.lang.reflect.Array;
import java.util.Arrays;

public final class ArrayHelper {
    public static <E> E combine(E a, E b) {
        Class<?> resCompType;
        Class<?> bCompType;
        if (!a.getClass().isArray() || !b.getClass().isArray()) {
            throw new IllegalArgumentException();
        }
        Class<?> aCompType = a.getClass().getComponentType();
        if (aCompType.isAssignableFrom(bCompType = b.getClass().getComponentType())) {
            resCompType = aCompType;
        } else if (bCompType.isAssignableFrom(aCompType)) {
            resCompType = bCompType;
        } else {
            throw new IllegalArgumentException();
        }
        int aLen = Array.getLength(a);
        int bLen = Array.getLength(b);
        Object result = Array.newInstance(resCompType, aLen + bLen);
        System.arraycopy(a, 0, result, 0, aLen);
        System.arraycopy(b, 0, result, aLen, bLen);
        return (E)result;
    }

    public static String[] copy(String[] toCopy) {
        String[] result = new String[toCopy.length];
        System.arraycopy(toCopy, 0, result, 0, toCopy.length);
        return result;
    }

    public static int[] copy(int[] toCopy) {
        int[] result = new int[toCopy.length];
        System.arraycopy(toCopy, 0, result, 0, toCopy.length);
        return result;
    }

    public static <T> boolean contains(T[] array, T element) {
        return Arrays.asList(array).contains(element);
    }

    public static int getOrLast(int[] array, int index) {
        if (index >= array.length) {
            return array[array.length - 1];
        }
        return array[index];
    }

    public static <T> T getOrLast(T[] array, int index) {
        if (index >= array.length) {
            return array[array.length - 1];
        }
        return array[index];
    }

    private ArrayHelper() {
    }
}

