/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.network.tile;

import com.codetaylor.mc.athenaeum.network.tile.ITileDataService;
import com.codetaylor.mc.athenaeum.network.tile.TileDataServiceContainer;
import com.codetaylor.mc.athenaeum.network.tile.TileDataServiceLogger;
import com.codetaylor.mc.athenaeum.network.tile.TileDataTracker;
import com.codetaylor.mc.athenaeum.network.tile.client.TileDataServiceClientMonitor;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileDataContainerBase;
import com.codetaylor.mc.athenaeum.spi.packet.CPacketTileEntityBase;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SCPacketTileData
extends CPacketTileEntityBase<SCPacketTileData> {
    private int serviceId;
    private PacketBuffer buffer;

    public SCPacketTileData() {
    }

    public SCPacketTileData(int serviceId, BlockPos origin, PacketBuffer buffer) {
        super(origin);
        this.serviceId = serviceId;
        this.buffer = buffer;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.serviceId = buf.readInt();
        int size = buf.readInt();
        this.buffer = new PacketBuffer(Unpooled.buffer((int)size));
        buf.readBytes((ByteBuf)this.buffer, size);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.serviceId);
        buf.writeInt(this.buffer.writerIndex());
        buf.writeBytes((ByteBuf)this.buffer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected IMessage onMessage(SCPacketTileData message, MessageContext ctx, TileEntity tileEntity) {
        TileDataContainerBase tile;
        TileDataTracker tracker;
        ITileDataService dataService;
        if (tileEntity instanceof TileDataContainerBase && (dataService = TileDataServiceContainer.find(message.serviceId)) != null && (tracker = dataService.getTracker(tile = (TileDataContainerBase)tileEntity)) != null) {
            try {
                tracker.updateClient(message.buffer);
                TileDataServiceClientMonitor.onClientPacketReceived(tracker, message.blockPos, message.buffer.writerIndex());
            }
            catch (Exception e) {
                TileDataServiceLogger.LOGGER.error("", (Throwable)e);
            }
        }
        return null;
    }
}

