/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.module;

import com.codetaylor.mc.athenaeum.module.IFMLStateEventRoute;
import com.codetaylor.mc.athenaeum.module.ModuleBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModuleEventRouter {
    private final List<ModuleBase> moduleList;
    private final Map<Class<? extends FMLStateEvent>, IFMLStateEventRoute> routes;

    public ModuleEventRouter(List<ModuleBase> moduleList) {
        this.moduleList = moduleList;
        this.routes = new HashMap<Class<? extends FMLStateEvent>, IFMLStateEventRoute>();
        this.routes.put(FMLConstructionEvent.class, event -> this.fireEvent(moduleBase -> moduleBase.onConstructionEvent((FMLConstructionEvent)event)));
        this.routes.put(FMLPreInitializationEvent.class, event -> {
            this.fireEvent(moduleBase -> moduleBase.onPreInitializationEvent((FMLPreInitializationEvent)event));
            if (event.getSide() == Side.CLIENT) {
                this.fireEvent(moduleBase -> moduleBase.onClientPreInitializationEvent((FMLPreInitializationEvent)event));
            }
        });
        this.routes.put(FMLInitializationEvent.class, event -> {
            this.fireEvent(moduleBase -> moduleBase.onInitializationEvent((FMLInitializationEvent)event));
            if (event.getSide() == Side.CLIENT) {
                this.fireEvent(moduleBase -> moduleBase.onClientInitializationEvent((FMLInitializationEvent)event));
            }
        });
        this.routes.put(FMLPostInitializationEvent.class, event -> {
            this.fireEvent(moduleBase -> moduleBase.onPostInitializationEvent((FMLPostInitializationEvent)event));
            if (event.getSide() == Side.CLIENT) {
                this.fireEvent(moduleBase -> moduleBase.onClientPostInitializationEvent((FMLPostInitializationEvent)event));
            }
        });
        this.routes.put(FMLLoadCompleteEvent.class, event -> this.fireEvent(moduleBase -> moduleBase.onLoadCompleteEvent((FMLLoadCompleteEvent)event)));
        this.routes.put(FMLServerAboutToStartEvent.class, event -> this.fireEvent(moduleBase -> moduleBase.onServerAboutToStartEvent((FMLServerAboutToStartEvent)event)));
        this.routes.put(FMLServerStartingEvent.class, event -> this.fireEvent(moduleBase -> moduleBase.onServerStartingEvent((FMLServerStartingEvent)event)));
        this.routes.put(FMLServerStartedEvent.class, event -> this.fireEvent(moduleBase -> moduleBase.onServerStartedEvent((FMLServerStartedEvent)event)));
        this.routes.put(FMLServerStoppingEvent.class, event -> this.fireEvent(moduleBase -> moduleBase.onServerStoppingEvent((FMLServerStoppingEvent)event)));
        this.routes.put(FMLServerStoppedEvent.class, event -> this.fireEvent(moduleBase -> moduleBase.onServerStoppedEvent((FMLServerStoppedEvent)event)));
    }

    <E extends FMLStateEvent> void routeFMLStateEvent(E event) {
        IFMLStateEventRoute route = this.routes.get(event.getClass());
        if (route == null) {
            throw new IllegalArgumentException("No route found for event: " + event.getClass());
        }
        route.routeEvent(event);
    }

    @SubscribeEvent
    public void onRegisterBlockEvent(RegistryEvent.Register<Block> event) {
        this.fireEvent(module -> module.onRegisterBlockEvent(event));
        this.onRegisterTileEntitiesEvent();
    }

    @SubscribeEvent
    public void onRegisterItemEvent(RegistryEvent.Register<Item> event) {
        this.fireEvent(module -> module.onRegisterItemEvent(event));
    }

    @SubscribeEvent
    public void onRegisterPotionEvent(RegistryEvent.Register<Potion> event) {
        this.fireEvent(module -> module.onRegisterPotionEvent(event));
    }

    @SubscribeEvent
    public void onRegisterBiomeEvent(RegistryEvent.Register<Biome> event) {
        this.fireEvent(module -> module.onRegisterBiomeEvent(event));
    }

    @SubscribeEvent
    public void onRegisterSoundEvent(RegistryEvent.Register<SoundEvent> event) {
        this.fireEvent(module -> module.onRegisterSoundEvent(event));
    }

    @SubscribeEvent
    public void onRegisterPotionTypeEvent(RegistryEvent.Register<PotionType> event) {
        this.fireEvent(module -> module.onRegisterPotionTypeEvent(event));
    }

    @SubscribeEvent
    public void onRegisterEnchantmentEvent(RegistryEvent.Register<Enchantment> event) {
        this.fireEvent(module -> module.onRegisterEnchantmentEvent(event));
    }

    @SubscribeEvent
    public void onRegisterVillagerProfessionEvent(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
        this.fireEvent(module -> module.onRegisterVillagerProfessionEvent(event));
    }

    @SubscribeEvent
    public void onRegisterEntityEvent(RegistryEvent.Register<EntityEntry> event) {
        this.fireEvent(module -> module.onRegisterEntityEvent(event));
    }

    @SubscribeEvent
    public void onRegisterRecipesEvent(RegistryEvent.Register<IRecipe> event) {
        this.fireEvent(module -> module.onRegisterRecipesEvent(event));
    }

    private void onRegisterTileEntitiesEvent() {
        this.fireEvent(ModuleBase::onRegisterTileEntitiesEvent);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientRegisterModelsEvent(ModelRegistryEvent event) {
        this.fireEvent(module -> module.onClientRegisterModelsEvent(event));
    }

    private void fireEvent(Consumer<ModuleBase> moduleConsumer) {
        for (ModuleBase module : this.moduleList) {
            moduleConsumer.accept(module);
        }
    }
}

