/*
 * Decompiled with CFR 0.152.
 */
package quaternary.simpletrophies.common.etc;

import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import quaternary.simpletrophies.common.etc.EnumTrophyVariant;
import quaternary.simpletrophies.common.item.SimpleTrophiesItems;
import quaternary.simpletrophies.common.tile.TileSimpleTrophy;

public class TrophyHelpers {
    public static int getCombinedColor(ItemStack stack) {
        if (stack.func_77942_o()) {
            return TrophyHelpers.getCombinedColor(stack.func_77978_p());
        }
        return 0xFFFFFF;
    }

    public static int getCombinedColor(TileSimpleTrophy tile) {
        return tile.displayedColorRed << 16 | tile.displayedColorGreen << 8 | tile.displayedColorBlue;
    }

    public static int getCombinedColor(NBTTagCompound nbt) {
        int red = nbt.func_74764_b("TrophyColorRed") ? nbt.func_74762_e("TrophyColorRed") : 255;
        int green = nbt.func_74764_b("TrophyColorGreen") ? nbt.func_74762_e("TrophyColorGreen") : 255;
        int blue = nbt.func_74764_b("TrophyColorBlue") ? nbt.func_74762_e("TrophyColorBlue") : 255;
        red = MathHelper.func_76125_a((int)red, (int)0, (int)255);
        green = MathHelper.func_76125_a((int)green, (int)0, (int)255);
        blue = MathHelper.func_76125_a((int)blue, (int)0, (int)255);
        return red << 16 | green << 8 | blue;
    }

    public static ItemStack getDisplayedStack(ItemStack stack) {
        if (stack.func_77942_o()) {
            return TrophyHelpers.getDisplayedStack(stack.func_77978_p());
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getDisplayedStack(NBTTagCompound nbt) {
        if (nbt.func_74764_b("TrophyItem")) {
            return new ItemStack(nbt.func_74775_l("TrophyItem"));
        }
        return ItemStack.field_190927_a;
    }

    public static String getDisplayedName(ItemStack stack) {
        if (stack.func_77942_o()) {
            return TrophyHelpers.getDisplayedName(stack.func_77978_p());
        }
        return "";
    }

    public static String getDisplayedName(NBTTagCompound nbt) {
        if (nbt.func_74764_b("TrophyName")) {
            return nbt.func_74779_i("TrophyName");
        }
        return "";
    }

    public static EnumTrophyVariant getDisplayedVariant(ItemStack stack) {
        if (stack.func_77942_o()) {
            return TrophyHelpers.getDisplayedVariant(stack.func_77978_p());
        }
        return EnumTrophyVariant.CLASSIC;
    }

    public static EnumTrophyVariant getDisplayedVariant(NBTTagCompound nbt) {
        if (nbt.func_74764_b("TrophyVariant")) {
            return EnumTrophyVariant.fromString(nbt.func_74779_i("TrophyVariant"));
        }
        return EnumTrophyVariant.CLASSIC;
    }

    public static long getEarnTime(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74763_f("TrophyEarnedAt");
        }
        return 0L;
    }

    public static void populateStackNBTFromTile(ItemStack stack, TileSimpleTrophy tile) {
        if (tile.displayedStack.func_190926_b() && tile.displayedName.isEmpty()) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        assert (nbt != null);
        nbt.func_179237_a(tile.writeToNBTInternal(new NBTTagCompound()));
    }

    public static void populateTileNBTFromStack(ItemStack stack, TileSimpleTrophy tile) {
        if (!stack.func_77942_o()) {
            tile.displayedName = "";
            tile.displayedStack = ItemStack.field_190927_a;
            tile.displayedColorRed = 255;
            tile.displayedColorGreen = 255;
            tile.displayedColorBlue = 255;
            tile.displayedVariant = EnumTrophyVariant.CLASSIC;
            tile.earnedTime = 0L;
        } else {
            tile.readFromNBTInternal(stack.func_77978_p());
        }
    }

    public static ItemStack createItemStackFromTile(@Nullable TileSimpleTrophy tile) {
        ItemStack stack = new ItemStack((Item)SimpleTrophiesItems.TROPHY);
        if (tile != null) {
            TrophyHelpers.populateStackNBTFromTile(stack, tile);
        }
        return stack;
    }
}

