/*
 * Decompiled with CFR 0.152.
 */
package primal_tech.recipes;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import primal_tech.ModBlocks;
import primal_tech.ModItems;
import primal_tech.configs.ConfigHandler;
import primal_tech.recipes.ClayKilnRecipes;
import primal_tech.recipes.StoneAnvilRecipes;
import primal_tech.recipes.WaterSawRecipes;
import primal_tech.recipes.WoodenBasinRecipes;

public class ModRecipes {
    public static final ItemStack NBT_FIRE_STICKS = new ItemStack(ModItems.FIRE_STICKS);
    public static IRecipe CLAY_KILN;
    public static IRecipe BONE_KNIFE;
    public static IRecipe STICK_BUNDLE;
    public static IRecipe FIBRE_TORCH;
    public static IRecipe CHARCOAL;
    public static IRecipe ROCK;
    public static IRecipe WOOD_CLUB;
    public static IRecipe STONE_CLUB;
    public static IRecipe BONE_CLUB;
    public static IRecipe PLANT_FIBRES;
    public static IRecipe TWINE;
    public static IRecipe FIRE_STICKS;
    public static IRecipe BONE_SWORD;
    public static IRecipe BONE_AXE;
    public static IRecipe BONE_PICKAXE;
    public static IRecipe BONE_SHOVEL;
    public static IRecipe BONE_SHEARS;
    public static IRecipe WOODEN_HOPPER;
    public static IRecipe CHARCOAL_HOPPER;
    public static IRecipe FLUID_BLADDER;
    public static IRecipe FLINT_SAW_BLADE;
    public static IRecipe STONE_MALLET;
    public static IRecipe WORK_STUMP;
    public static IRecipe WORK_STUMP_II;
    public static IRecipe STONE_GRILL;
    public static IRecipe WATER_SAW;
    public static IRecipe STONE_ANVIL;
    public static IRecipe WOODEN_BASIN;
    public static IRecipe LEAF_BED;

    public static void init() {
        ModRecipes.makeNBTStuffForMePlease();
        CLAY_KILN = new ShapedOreRecipe(ModRecipes.getResource("recipe_clay_kiln"), new ItemStack((Item)ModBlocks.CLAY_KILN_ITEM), new Object[]{"CCC", "C C", "CCC", Character.valueOf('C'), new ItemStack(Items.field_151119_aD)});
        CLAY_KILN.setRegistryName(ModRecipes.getResource("recipe_clay_kiln"));
        BONE_PICKAXE = new ShapedOreRecipe(ModRecipes.getResource("recipe_bone_pickaxe"), new ItemStack(ModItems.BONE_PICKAXE, 1), new Object[]{"XXX", " # ", " # ", Character.valueOf('#'), "stickWood", Character.valueOf('X'), "flakeBone"});
        BONE_PICKAXE.setRegistryName(ModRecipes.getResource("recipe_bone_pickaxe"));
        BONE_SHOVEL = new ShapedOreRecipe(ModRecipes.getResource("recipe_bone_shovel"), new ItemStack(ModItems.BONE_SHOVEL, 1), new Object[]{"X", "#", "#", Character.valueOf('#'), "stickWood", Character.valueOf('X'), "flakeBone"});
        BONE_SHOVEL.setRegistryName(ModRecipes.getResource("recipe_bone_shovel"));
        BONE_AXE = new ShapedOreRecipe(ModRecipes.getResource("recipe_bone_axe"), new ItemStack(ModItems.BONE_AXE, 1), new Object[]{"XX", "X#", " #", Character.valueOf('#'), "stickWood", Character.valueOf('X'), "flakeBone"});
        BONE_AXE.setRegistryName(ModRecipes.getResource("recipe_bone_axe"));
        BONE_SWORD = new ShapedOreRecipe(ModRecipes.getResource("recipe_bone_sword"), new ItemStack((Item)ModItems.BONE_SWORD, 1), new Object[]{"X", "X", "#", Character.valueOf('#'), "stickWood", Character.valueOf('X'), "flakeBone"});
        BONE_SWORD.setRegistryName(ModRecipes.getResource("recipe_bone_sword"));
        BONE_SHEARS = new ShapedOreRecipe(ModRecipes.getResource("recipe_bone_shears"), new ItemStack(ModItems.BONE_SHEARS, 1), new Object[]{" #", "# ", Character.valueOf('#'), "flakeBone"});
        BONE_SHEARS.setRegistryName(ModRecipes.getResource("recipe_bone_shears"));
        BONE_KNIFE = new ShapedOreRecipe(ModRecipes.getResource("recipe_bone_knife"), new ItemStack((Item)ModItems.BONE_KNIFE), new Object[]{" B", "S ", Character.valueOf('B'), "flakeBone", Character.valueOf('S'), "stickWood"});
        BONE_KNIFE.setRegistryName(ModRecipes.getResource("recipe_bone_knife"));
        STICK_BUNDLE = new ShapedOreRecipe(ModRecipes.getResource("recipe_stick_bundle"), new ItemStack((Item)ModBlocks.STICK_BUNDLE_ITEM), new Object[]{"STS", "SSS", "STS", Character.valueOf('T'), "string", Character.valueOf('S'), "stickWood"});
        STICK_BUNDLE.setRegistryName(ModRecipes.getResource("recipe_stick_bundle"));
        FIBRE_TORCH = new ShapedOreRecipe(ModRecipes.getResource("recipe_fibre_torch"), new ItemStack((Item)ModBlocks.FIBRE_TORCH_ITEM, 4, 0), new Object[]{"F", "S", Character.valueOf('F'), new ItemStack(ModItems.PLANT_FIBRES, 1, 0), Character.valueOf('S'), "stickWood"});
        FIBRE_TORCH.setRegistryName(ModRecipes.getResource("recipe_fibre_torch"));
        CHARCOAL = new ShapelessOreRecipe(ModRecipes.getResource("recipe_charcoal"), new ItemStack(Items.field_151044_h, 4, 1), new Object[]{new ItemStack((Item)ModBlocks.CHARCOAL_BLOCK_ITEM)});
        CHARCOAL.setRegistryName(ModRecipes.getResource("recipe_charcoal"));
        ROCK = new ShapelessOreRecipe(ModRecipes.getResource("recipe_rock"), new ItemStack(ModItems.ROCK, 4, 0), new Object[]{"cobblestone"});
        ROCK.setRegistryName(ModRecipes.getResource("recipe_rock"));
        WOOD_CLUB = new ShapedOreRecipe(ModRecipes.getResource("recipe_wood_club"), new ItemStack(ModItems.WOOD_CLUB), new Object[]{"L", "S", Character.valueOf('L'), "logWood", Character.valueOf('S'), "stickWood"});
        WOOD_CLUB.setRegistryName(ModRecipes.getResource("recipe_wood_club"));
        STONE_CLUB = new ShapedOreRecipe(ModRecipes.getResource("recipe_stone_club"), new ItemStack(ModItems.STONE_CLUB), new Object[]{"C", "S", Character.valueOf('C'), "cobblestone", Character.valueOf('S'), "stickWood"});
        STONE_CLUB.setRegistryName(ModRecipes.getResource("recipe_stone_club"));
        BONE_CLUB = new ShapedOreRecipe(ModRecipes.getResource("recipe_bone_club"), new ItemStack(ModItems.BONE_CLUB), new Object[]{"B", "S", Character.valueOf('B'), new ItemStack(Blocks.field_189880_di), Character.valueOf('S'), "stickWood"});
        BONE_CLUB.setRegistryName(ModRecipes.getResource("recipe_bone_club"));
        PLANT_FIBRES = new ShapelessOreRecipe(ModRecipes.getResource("recipe_plant_fibres"), new ItemStack(ModItems.PLANT_FIBRES), new Object[]{new ItemStack((Block)Blocks.field_150329_H, 1, Short.MAX_VALUE), new ItemStack((Item)ModItems.BONE_KNIFE, 1, Short.MAX_VALUE)});
        PLANT_FIBRES.setRegistryName(ModRecipes.getResource("recipe_plant_fibres"));
        TWINE = new ShapelessOreRecipe(ModRecipes.getResource("recipe_twine"), new ItemStack(ModItems.TWINE, 3, 0), new Object[]{new ItemStack(ModItems.PLANT_FIBRES), new ItemStack(ModItems.PLANT_FIBRES), new ItemStack(ModItems.PLANT_FIBRES)});
        TWINE.setRegistryName(ModRecipes.getResource("recipe_twine"));
        FIRE_STICKS = new ShapelessOreRecipe(ModRecipes.getResource("recipe_fire_sticks"), NBT_FIRE_STICKS, new Object[]{"stickWood", new ItemStack((Item)ModItems.BONE_KNIFE, 1, Short.MAX_VALUE)});
        FIRE_STICKS.setRegistryName(ModRecipes.getResource("recipe_fire_sticks"));
        WOODEN_HOPPER = new ShapedOreRecipe(ModRecipes.getResource("recipe_wooden_hopper"), new ItemStack((Item)ModBlocks.WOODEN_HOPPER_ITEM), new Object[]{"I I", "ICI", " I ", Character.valueOf('I'), "plankWood", Character.valueOf('C'), new ItemStack(Blocks.field_150415_aT)});
        WOODEN_HOPPER.setRegistryName(ModRecipes.getResource("recipe_wooden_hopper"));
        CHARCOAL_HOPPER = new ShapedOreRecipe(ModRecipes.getResource("recipe_charcoal_hopper"), new ItemStack((Item)ModBlocks.CHARCOAL_HOPPER_ITEM), new Object[]{"I I", "ICI", " I ", Character.valueOf('I'), new ItemStack((Item)ModBlocks.CHARCOAL_BLOCK_ITEM), Character.valueOf('C'), new ItemStack(Blocks.field_150415_aT)});
        CHARCOAL_HOPPER.setRegistryName(ModRecipes.getResource("recipe_charcoal_hopper"));
        FLUID_BLADDER = new ShapedOreRecipe(ModRecipes.getResource("recipe_fluid_bladder"), new ItemStack(ModItems.FLUID_BLADDER), new Object[]{"TL ", "L L", " L ", Character.valueOf('L'), new ItemStack(Items.field_151116_aA), Character.valueOf('T'), "string"});
        FLUID_BLADDER.setRegistryName(ModRecipes.getResource("recipe_fluid_bladder"));
        FLINT_SAW_BLADE = new ShapedOreRecipe(ModRecipes.getResource("recipe_flint_saw_blade"), new ItemStack(ModItems.FLINT_SAW_BLADE), new Object[]{"F F", " B ", "F F", Character.valueOf('F'), new ItemStack(Items.field_151145_ak), Character.valueOf('B'), new ItemStack((Item)ModBlocks.FLINT_BLOCK_ITEM)});
        FLINT_SAW_BLADE.setRegistryName(ModRecipes.getResource("recipe_flint_saw_blade"));
        STONE_MALLET = new ShapedOreRecipe(ModRecipes.getResource("recipe_stone_mallet"), new ItemStack(ModItems.STONE_MALLET), new Object[]{" BS", " SB", "S  ", Character.valueOf('B'), "stone", Character.valueOf('S'), "stickWood"});
        STONE_MALLET.setRegistryName(ModRecipes.getResource("recipe_stone_mallet"));
        WORK_STUMP = new ShapedOreRecipe(ModRecipes.getResource("recipe_work_stump"), new ItemStack((Item)ModBlocks.WORK_STUMP_ITEM), new Object[]{"S", "L", Character.valueOf('S'), "slabWood", Character.valueOf('L'), "logWood"});
        WORK_STUMP.setRegistryName(ModRecipes.getResource("recipe_work_stump"));
        WORK_STUMP_II = new ShapedOreRecipe(ModRecipes.getResource("recipe_work_stump_2"), new ItemStack((Item)ModBlocks.WORK_STUMP_II_ITEM), new Object[]{"PPP", "PWP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('W'), new ItemStack((Item)ModBlocks.WORK_STUMP_ITEM)});
        WORK_STUMP_II.setRegistryName(ModRecipes.getResource("recipe_work_stump_2"));
        STONE_GRILL = new ShapedOreRecipe(ModRecipes.getResource("recipe_stone_grill"), new ItemStack((Item)ModBlocks.STONE_GRILL_ITEM), new Object[]{"SSS", "C C", " C ", Character.valueOf('S'), new ItemStack((Block)Blocks.field_150333_U, 1, BlockStoneSlab.EnumType.COBBLESTONE.ordinal()), Character.valueOf('C'), "cobblestone"});
        STONE_GRILL.setRegistryName(ModRecipes.getResource("recipe_stone_grill"));
        STONE_ANVIL = new ShapedOreRecipe(ModRecipes.getResource("recipe_stone_anvil"), new ItemStack((Item)ModBlocks.STONE_ANVIL_ITEM), new Object[]{"H", "S", Character.valueOf('H'), new ItemStack((Block)Blocks.field_150333_U, 1, BlockStoneSlab.EnumType.STONE.ordinal()), Character.valueOf('S'), "stone"});
        STONE_ANVIL.setRegistryName(ModRecipes.getResource("recipe_stone_anvil"));
        WATER_SAW = new ShapedOreRecipe(ModRecipes.getResource("recipe_water_saw"), new ItemStack((Item)ModBlocks.WATER_SAW_ITEM), new Object[]{"PBP", "SLS", "PLP", Character.valueOf('P'), new ItemStack(Blocks.field_150452_aw), Character.valueOf('B'), new ItemStack(ModItems.FLINT_SAW_BLADE), Character.valueOf('S'), "stickWood", Character.valueOf('L'), "logWood"});
        WATER_SAW.setRegistryName(ModRecipes.getResource("recipe_water_saw"));
        WOODEN_BASIN = new ShapedOreRecipe(ModRecipes.getResource("recipe_wooden_basin"), new ItemStack((Item)ModBlocks.WOODEN_BASIN_ITEM), new Object[]{"PSP", "PPP", "B B", Character.valueOf('P'), "plankWood", Character.valueOf('S'), "stickWood", Character.valueOf('B'), "stone"});
        WOODEN_BASIN.setRegistryName(ModRecipes.getResource("recipe_wooden_basin"));
        LEAF_BED = new ShapedOreRecipe(ModRecipes.getResource("recipe_leaf_bed"), new ItemStack(ModItems.LEAF_BED_ITEM), new Object[]{"LLS", "HHH", Character.valueOf('L'), "treeLeaves", Character.valueOf('S'), "slabWood", Character.valueOf('H'), new ItemStack(Blocks.field_150407_cf)});
        LEAF_BED.setRegistryName(ModRecipes.getResource("recipe_leaf_bed"));
    }

    private static void makeNBTStuffForMePlease() {
        NBT_FIRE_STICKS.func_77982_d(new NBTTagCompound());
        NBT_FIRE_STICKS.func_77978_p().func_74768_a("rubbingCount", 0);
        NBT_FIRE_STICKS.func_77978_p().func_74757_a("animate", false);
    }

    public static void addKilnRecipes() {
        for (int items = 0; items < ConfigHandler.CLAY_KILN_RECIPES.length; ++items) {
            ArrayList<String> outputItemList = new ArrayList<String>();
            ArrayList<String> inputItemList = new ArrayList<String>();
            ArrayList<String> finalOutPutItem = new ArrayList<String>();
            ArrayList<String> finalInPutItem = new ArrayList<String>();
            String[] entry = ConfigHandler.CLAY_KILN_RECIPES[items].trim().split("#");
            if (entry.length != 3) {
                throw new IllegalArgumentException("Illegal entry found when reading Primal Tech config file: " + ConfigHandler.CLAY_KILN_RECIPES[items]);
            }
            outputItemList.add(entry[0]);
            inputItemList.add(entry[1]);
            int itemCookTime = Integer.valueOf(entry[2]);
            String[] finalEntry = ((String)outputItemList.get(0)).trim().split(",");
            if (finalEntry.length != 2) {
                throw new IllegalArgumentException("Illegal entry found when reading Primal Tech config file: " + (String)outputItemList.get(0));
            }
            finalOutPutItem.add(finalEntry[0]);
            finalOutPutItem.add(finalEntry[1]);
            String[] finalEntry2 = ((String)inputItemList.get(0)).trim().split(",");
            if (finalEntry2.length != 2) {
                throw new IllegalArgumentException("Illegal entry found when reading Primal Tech config file: " + (String)inputItemList.get(0));
            }
            finalInPutItem.add(finalEntry2[0]);
            finalInPutItem.add(finalEntry2[1]);
            ItemStack outStack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation((String)finalOutPutItem.get(0))), 1, Integer.valueOf((String)finalOutPutItem.get(1)).intValue());
            ItemStack inStack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation((String)finalInPutItem.get(0))), 1, Integer.valueOf((String)finalInPutItem.get(1)).intValue());
            if (outStack.func_190926_b() || inStack.func_190926_b()) continue;
            ClayKilnRecipes.addRecipe(outStack, inStack, itemCookTime);
        }
    }

    public static void addWaterSawRecipes() {
        for (int items = 0; items < ConfigHandler.WATER_SAW_RECIPES.length; ++items) {
            ArrayList<String> outputItemList = new ArrayList<String>();
            ArrayList<String> inputItemList = new ArrayList<String>();
            ArrayList<String> finalOutPutItem = new ArrayList<String>();
            ArrayList<String> finalInPutItem = new ArrayList<String>();
            String[] entry = ConfigHandler.WATER_SAW_RECIPES[items].trim().split("#");
            if (entry.length != 3) {
                throw new IllegalArgumentException("Illegal entry found when reading Primal Tech config file: " + ConfigHandler.WATER_SAW_RECIPES[items]);
            }
            outputItemList.add(entry[0]);
            inputItemList.add(entry[1]);
            int choppingTime = Integer.valueOf(entry[2]);
            String[] finalEntry = ((String)outputItemList.get(0)).trim().split(",");
            if (finalEntry.length != 3) {
                throw new IllegalArgumentException("Illegal entry found when reading Primal Tech config file: " + (String)outputItemList.get(0));
            }
            finalOutPutItem.add(finalEntry[0]);
            finalOutPutItem.add(finalEntry[1]);
            finalOutPutItem.add(finalEntry[2]);
            String[] finalEntry2 = ((String)inputItemList.get(0)).trim().split(",");
            if (finalEntry2.length != 2) {
                throw new IllegalArgumentException("Illegal entry found when reading Primal Tech config file: " + (String)inputItemList.get(0));
            }
            finalInPutItem.add(finalEntry2[0]);
            finalInPutItem.add(finalEntry2[1]);
            ItemStack outStack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation((String)finalOutPutItem.get(0))), Integer.valueOf((String)finalOutPutItem.get(2)).intValue(), Integer.valueOf((String)finalOutPutItem.get(1)).intValue());
            ItemStack inStack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation((String)finalInPutItem.get(0))), 1, Integer.valueOf((String)finalInPutItem.get(1)).intValue());
            if (outStack.func_190926_b() || inStack.func_190926_b()) continue;
            WaterSawRecipes.addRecipe(outStack, inStack, choppingTime);
        }
    }

    public static void addStoneAnvilRecipes() {
        for (int items = 0; items < ConfigHandler.STONE_ANVIL_RECIPES.length; ++items) {
            ArrayList<String> outputItemList = new ArrayList<String>();
            ArrayList<String> inputItemList = new ArrayList<String>();
            ArrayList<String> finalOutPutItem = new ArrayList<String>();
            ArrayList<String> finalInPutItem = new ArrayList<String>();
            String[] entry = ConfigHandler.STONE_ANVIL_RECIPES[items].trim().split("#");
            if (entry.length != 2) {
                throw new IllegalArgumentException("Illegal entry found when reading Primal Tech config file: " + ConfigHandler.STONE_ANVIL_RECIPES[items]);
            }
            outputItemList.add(entry[0]);
            inputItemList.add(entry[1]);
            String[] finalEntry = ((String)outputItemList.get(0)).trim().split(",");
            if (finalEntry.length != 3) {
                throw new IllegalArgumentException("Illegal entry found when reading Primal Tech config file: " + (String)outputItemList.get(0));
            }
            finalOutPutItem.add(finalEntry[0]);
            finalOutPutItem.add(finalEntry[1]);
            finalOutPutItem.add(finalEntry[2]);
            String[] finalEntry2 = ((String)inputItemList.get(0)).trim().split(",");
            if (finalEntry2.length != 2) {
                throw new IllegalArgumentException("Illegal entry found when reading Primal Tech config file: " + (String)inputItemList.get(0));
            }
            finalInPutItem.add(finalEntry2[0]);
            finalInPutItem.add(finalEntry2[1]);
            ItemStack outStack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation((String)finalOutPutItem.get(0))), Integer.valueOf((String)finalOutPutItem.get(2)).intValue(), Integer.valueOf((String)finalOutPutItem.get(1)).intValue());
            ItemStack inStack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation((String)finalInPutItem.get(0))), 1, Integer.valueOf((String)finalInPutItem.get(1)).intValue());
            if (outStack.func_190926_b() || inStack.func_190926_b()) continue;
            StoneAnvilRecipes.addRecipe(outStack, inStack);
        }
    }

    public static void addWoodenBasinRecipes() {
        for (int items = 0; items < ConfigHandler.WOODEN_BASIN_RECIPES.length; ++items) {
            ArrayList<String> outputItemList = new ArrayList<String>();
            ArrayList<String> inputItemList = new ArrayList<String>();
            String[] entry = ConfigHandler.WOODEN_BASIN_RECIPES[items].trim().split("#");
            if (entry.length != 3) {
                throw new IllegalArgumentException("Illegal entry found when reading Primal Tech config file: " + ConfigHandler.WOODEN_BASIN_RECIPES[items]);
            }
            outputItemList.add(entry[0]);
            if (!FluidRegistry.isFluidRegistered((String)entry[1])) {
                throw new IllegalArgumentException("Illegal Fluid entry found when reading Primal Tech config file: " + ConfigHandler.WOODEN_BASIN_RECIPES[items]);
            }
            Fluid inputFluid = FluidRegistry.getFluid((String)entry[1]);
            inputItemList.add(entry[2]);
            String[] finalOutPutEntry = ((String)outputItemList.get(0)).trim().split(",");
            if (finalOutPutEntry.length != 3) {
                throw new IllegalArgumentException("Illegal entry found when reading Primal Tech config file: " + (String)outputItemList.get(0));
            }
            ItemStack outStack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(finalOutPutEntry[0])), Integer.valueOf(finalOutPutEntry[2]).intValue(), Integer.valueOf(finalOutPutEntry[1]).intValue());
            String[] finalInputEntry = ((String)inputItemList.get(0)).trim().split(",");
            if (finalInputEntry.length < 2) {
                throw new IllegalArgumentException("Illegal entry found when reading Primal Tech config file: " + (String)inputItemList.get(0));
            }
            ItemStack inStack1 = ItemStack.field_190927_a;
            ItemStack inStack2 = ItemStack.field_190927_a;
            ItemStack inStack3 = ItemStack.field_190927_a;
            ItemStack inStack4 = ItemStack.field_190927_a;
            if (finalInputEntry.length > 0) {
                inStack1 = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(finalInputEntry[0])), 1, Integer.valueOf(finalInputEntry[1]).intValue());
            }
            if (finalInputEntry.length > 2) {
                inStack2 = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(finalInputEntry[2])), 1, Integer.valueOf(finalInputEntry[3]).intValue());
            }
            if (finalInputEntry.length > 4) {
                inStack3 = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(finalInputEntry[4])), 1, Integer.valueOf(finalInputEntry[5]).intValue());
            }
            if (finalInputEntry.length > 6) {
                inStack4 = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(finalInputEntry[6])), 1, Integer.valueOf(finalInputEntry[7]).intValue());
            }
            if (outStack.func_190926_b() || inStack1.func_190926_b()) continue;
            WoodenBasinRecipes.addRecipe(outStack, inputFluid, inStack1, inStack2, inStack3, inStack4);
        }
    }

    private static ResourceLocation getResource(String inName) {
        return new ResourceLocation("primal_tech", inName);
    }

    @Mod.EventBusSubscriber(modid="primal_tech")
    public static class RegistrationHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerOreDictEntries(RegistryEvent.Register<Item> event) {
            OreDictionary.registerOre((String)"string", (Item)ModItems.TWINE);
            OreDictionary.registerOre((String)"flakeBone", (Item)ModItems.BONE_SHARD);
        }
    }

    @Mod.EventBusSubscriber(modid="primal_tech")
    public static class RegistrationHandlerRecipes {
        @SubscribeEvent
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            ModRecipes.init();
            IForgeRegistry registry = event.getRegistry();
            event.getRegistry().registerAll((IForgeRegistryEntry[])new IRecipe[]{CLAY_KILN, BONE_KNIFE, STICK_BUNDLE, FIBRE_TORCH, CHARCOAL, ROCK, WOOD_CLUB, STONE_CLUB, BONE_CLUB, PLANT_FIBRES, TWINE, FIRE_STICKS, BONE_SWORD, BONE_AXE, BONE_PICKAXE, BONE_SHOVEL, BONE_SHEARS, WOODEN_HOPPER, CHARCOAL_HOPPER, FLUID_BLADDER, FLINT_SAW_BLADE, STONE_MALLET, WORK_STUMP, WORK_STUMP_II, STONE_GRILL, WATER_SAW, STONE_ANVIL, WOODEN_BASIN, LEAF_BED});
        }
    }
}

