/*
 * Decompiled with CFR 0.152.
 */
package primal_tech.client.render;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import primal_tech.tiles.TileEntityWoodenBasin;

@SideOnly(value=Side.CLIENT)
public class TileEntityWoodenBasinRenderer
extends TileEntitySpecialRenderer<TileEntityWoodenBasin> {
    public void render(TileEntityWoodenBasin tile, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        if (tile == null || !tile.func_145830_o()) {
            return;
        }
        float fluidLevel = tile.tank.getFluidAmount();
        float height = 0.0625f;
        if (fluidLevel > 0.0f) {
            FluidStack fluidStack = new FluidStack(tile.tank.getFluid(), 100);
            height = 0.375f / (float)tile.tank.getCapacity() * (float)tile.tank.getFluidAmount();
            TextureAtlasSprite fluidStillSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidStack.getFluid().getStill().toString());
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            int fluidColor = fluidStack.getFluid().getColor(fluidStack);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)(y + 0.25), (double)z);
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_147499_a(TextureMap.field_110575_b);
            this.setGLColorFromInt(fluidColor);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            float yMin = 0.0f;
            float xMax = 1.625f;
            float zMax = 1.625f;
            float xMin = 0.375f;
            float zMin = 0.375f;
            yMin = 0.0f;
            if (fluidLevel > 2000.0f) {
                xMax = 1.75f;
                zMax = 1.75f;
                xMin = 0.25f;
                zMin = 0.25f;
                yMin = 0.0f;
            }
            this.renderCuboid(buffer, xMax, xMin, yMin, height, zMin, zMax, fluidStillSprite);
            tessellator.func_78381_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        int itemBob = tile.getItemBob();
        int stirProgress = tile.getStirProgress();
        int prevStirProgress = tile.getPrevStirProgress();
        float stirTicks = (float)stirProgress + (float)(stirProgress - prevStirProgress) * partialTick;
        double itemY = y + 0.25 + (double)height;
        Random rand = new Random();
        rand.setSeed(tile.func_174877_v().func_177958_n() + tile.func_174877_v().func_177956_o() + tile.func_174877_v().func_177952_p());
        for (int i = 0; i <= 3; ++i) {
            float randRot = rand.nextFloat() * 360.0f;
            double xo = -0.2 + (double)rand.nextFloat() * 0.4;
            double zo = -0.2 + (double)rand.nextFloat() * 0.4;
            double rot = stirTicks < 90.0f && fluidLevel > 0.0f ? (double)stirTicks * 4.0 + 45.0 + (double)randRot : 45.0 + (double)randRot;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)0.0, (double)(z + 0.5));
            GlStateManager.func_179114_b((float)((float)(-rot)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)xo, (double)0.0, (double)zo);
            this.renderItemInSlot(tile, i, 0.0, itemY, 0.0, fluidLevel > 0.0f ? (i % 2 == 0 ? (double)itemBob * 0.01 : (double)(-itemBob + 20) * 0.01) : 0.0, -rot);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.25f), (float)((float)z + 0.5f));
        GlStateManager.func_179114_b((float)(stirTicks * 4.0f), (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)35.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.func_147499_a(TextureMap.field_110575_b);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.125f, (float)0.6875f, (float)0.125f);
        Minecraft.func_71410_x().func_175602_ab().func_175016_a(Blocks.field_150364_r.func_176223_P(), 1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    private void renderItemInSlot(TileEntityWoodenBasin tile, int slotIndex, double x, double y, double z, double itemBob, double rotation) {
        if (!tile.func_70301_a(slotIndex).func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179139_a((double)0.25, (double)0.25, (double)0.25);
            GlStateManager.func_179137_b((double)0.0, (double)itemBob, (double)0.0);
            GlStateManager.func_179114_b((float)((float)rotation), (float)0.0f, (float)1.0f, (float)0.0f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(tile.func_70301_a(slotIndex), ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.func_179121_F();
        }
    }

    private void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
    }

    private void renderCuboid(BufferBuilder buffer, float xMax, float xMin, float yMin, float height, float zMin, float zMax, TextureAtlasSprite textureAtlasSprite) {
        double uMin = textureAtlasSprite.func_94209_e();
        double uMax = textureAtlasSprite.func_94212_f();
        double vMin = textureAtlasSprite.func_94206_g();
        double vMax = textureAtlasSprite.func_94210_h();
        double vHeight = vMax - vMin;
        this.addVertexWithUV(buffer, xMax, height, zMax, uMax, vMin);
        this.addVertexWithUV(buffer, xMax, height, zMin, uMin, vMin);
        this.addVertexWithUV(buffer, xMin, height, zMin, uMin, vMax);
        this.addVertexWithUV(buffer, xMin, height, zMax, uMax, vMax);
    }

    private void addVertexWithUV(BufferBuilder buffer, float x, float y, float z, double u, double v) {
        buffer.func_181662_b((double)(x / 2.0f), (double)y, (double)(z / 2.0f)).func_187315_a(u, v).func_181675_d();
    }

    private void addVertexWithColor(BufferBuilder buffer, float x, float y, float z, float red, float green, float blue, float alpha) {
        buffer.func_181662_b((double)(x / 2.0f), (double)y, (double)(z / 2.0f)).func_181666_a(red, green, blue, alpha).func_181675_d();
    }
}

