/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.server.command;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jline.utils.Log;
import yuudaari.soulus.Soulus;
import yuudaari.soulus.common.network.SoulsPacketHandler;
import yuudaari.soulus.common.network.packet.client.LocationCommand;

public class SoulusCommand
extends CommandBase {
    private static final String[] COMMANDS = new String[]{"location", "reload"};

    public String func_71517_b() {
        return "soulus";
    }

    public String func_71518_a(ICommandSender sender) {
        return "command.soulus:soulus.usage";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        ArrayList<String> result = new ArrayList<String>();
        if (args.length == 1) {
            for (String command : COMMANDS) {
                if (!command.startsWith(args[0])) continue;
                result.add(command);
            }
        }
        return result;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender ics, String[] args) throws CommandException {
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("location")) {
                this.executeLocation(ics);
                return;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                this.executeReload(ics);
                return;
            }
        }
        throw new SoulusCommandException("soulus", "invalid_syntax", new TextComponentTranslation(this.func_71518_a(ics), new Object[0]));
    }

    private void executeReload(ICommandSender ics) throws SoulusCommandException {
        try {
            Soulus.reloadConfigs(true, true);
            ics.func_145747_a((ITextComponent)new TextComponentTranslation("command.soulus:reload.success", new Object[0]));
        }
        catch (Exception e) {
            Log.error((Object[])new Object[]{e});
            throw new SoulusCommandException("reload", "failed", e.getMessage());
        }
    }

    private void executeLocation(ICommandSender ics) {
        Entity e = ics.func_174793_f();
        if (e instanceof EntityPlayerMP) {
            SoulsPacketHandler.INSTANCE.sendTo((IMessage)new LocationCommand((EntityPlayer)((EntityPlayerMP)e)), (EntityPlayerMP)e);
        }
    }

    public static class SoulusCommandException
    extends CommandException {
        private static final long serialVersionUID = 293815792834L;

        public SoulusCommandException(String command, String message, Object ... args) {
            super("command.soulus:" + command + "." + message, args);
        }
    }
}

