/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.util.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import yuudaari.soulus.common.util.Logger;
import yuudaari.soulus.common.util.serializer.FieldSerializer;

public abstract class MapSerializer<K, V>
extends FieldSerializer<Map<K, V>> {
    @Override
    public JsonElement serialize(Class<?> objectType, Map<K, V> object) {
        JsonObject result = new JsonObject();
        try {
            for (Map.Entry<K, V> entry : object.entrySet()) {
                String key = this.serializeKey(entry.getKey());
                JsonElement value = this.serializeValue(entry.getValue());
                result.add(key, value);
            }
        }
        catch (Exception e) {
            Logger.warn("Couldn't serialize map:");
            Logger.error(e);
            result = new JsonObject();
        }
        return result;
    }

    @Override
    public Map<K, V> deserialize(Class<?> requestedType, JsonElement json) {
        if (json == null || !(json instanceof JsonObject)) {
            Logger.warn("Not a Json Object");
            return null;
        }
        HashMap<K, V> map = new HashMap<K, V>();
        try {
            for (Map.Entry jsonConfig : json.getAsJsonObject().entrySet()) {
                K key = this.deserializeKey((String)jsonConfig.getKey());
                V value = this.deserializeValue((JsonElement)jsonConfig.getValue());
                map.put(key, value);
            }
        }
        catch (Exception e) {
            Logger.warn("Unable to deserialize map:");
            Logger.error(e);
            map = new HashMap();
        }
        return map;
    }

    public abstract String serializeKey(K var1);

    public abstract K deserializeKey(String var1);

    public abstract JsonElement serializeValue(V var1) throws Exception;

    public abstract V deserializeValue(JsonElement var1) throws Exception;

    public static abstract class OfStringKeys<V>
    extends MapSerializer<String, V> {
        @Override
        public String serializeKey(String key) {
            return key;
        }

        @Override
        public String deserializeKey(String key) {
            return key;
        }
    }
}

