/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureMap {
    public final Map<BlockPos, BlockValidator> blocks = new HashMap<BlockPos, BlockValidator>();

    public StructureMap addBlock(int x, int y, int z, BlockValidator validator) {
        this.blocks.put(new BlockPos(x, y, z), validator);
        return this;
    }

    public StructureMap addRowX(int x, int y, int z, int length, BlockValidator validator) {
        for (int i = 0; i < length; ++i) {
            this.addBlock(x + i, y, z, validator);
        }
        return this;
    }

    public StructureMap addRowZ(int x, int y, int z, int length, BlockValidator validator) {
        for (int i = 0; i < length; ++i) {
            this.addBlock(x, y, z + i, validator);
        }
        return this;
    }

    public StructureMap addColumn(int x, int y, int z, int height, BlockValidator validator) {
        for (int i = 0; i < height; ++i) {
            this.addBlock(x, y + i, z, validator);
        }
        return this;
    }

    public boolean isValid(World world, BlockPos pos) {
        return this.isValid(world, pos, EnumFacing.NORTH);
    }

    public boolean isValid(World world, BlockPos pos, EnumFacing facing) {
        return this.loopBlocks(world, pos, facing, (pos2, validator) -> {
            if (!validator.validate(pos, world, pos2, world.func_180495_p(pos2))) {
                return false;
            }
            return null;
        }, true);
    }

    public Boolean loopBlocks(World world, BlockPos pos, EnumFacing facing, BlockLoop loop) {
        return this.loopBlocks(world, pos, facing, loop, null);
    }

    public Boolean loopBlocks(World world, BlockPos pos, EnumFacing facing, BlockLoop loop, Boolean defaultResult) {
        EnumFacing z = facing;
        EnumFacing x = facing.func_176746_e();
        EnumFacing y = EnumFacing.UP;
        for (Map.Entry<BlockPos, BlockValidator> entry : this.blocks.entrySet()) {
            BlockPos mapPos = entry.getKey();
            BlockPos offsetPosition = pos.func_177967_a(x, mapPos.func_177958_n()).func_177967_a(y, mapPos.func_177956_o()).func_177967_a(z, mapPos.func_177952_p());
            Boolean result = loop.handle(offsetPosition, entry.getValue());
            if (result == null) continue;
            return result;
        }
        return defaultResult;
    }

    public static interface BlockValidator {
        public boolean validate(BlockPos var1, World var2, BlockPos var3, IBlockState var4);

        public static BlockValidator byBlockState(IBlockState ... validStates) {
            return (pos, world, checkPos, state) -> {
                for (IBlockState validState : validStates) {
                    if (!state.equals(validState)) continue;
                    return true;
                }
                return false;
            };
        }

        public static BlockValidator byBlock(Block ... validBlocks) {
            return (pos, world, checkPos, state) -> {
                for (Block validBlock : validBlocks) {
                    if (!state.func_177230_c().equals(validBlock)) continue;
                    return true;
                }
                return false;
            };
        }
    }

    public static interface BlockLoop {
        public Boolean handle(BlockPos var1, BlockValidator var2);
    }
}

