/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.util;

import java.util.Random;
import yuudaari.soulus.common.util.serializer.Serializable;
import yuudaari.soulus.common.util.serializer.Serialized;

@Serializable
public class Range {
    @Serialized
    public Double min;
    @Serialized
    public Double max;

    public Range() {
    }

    public Range(Number min, Number max) {
        this.min = min.doubleValue();
        this.max = max.doubleValue();
    }

    public double get(Random random) {
        return random.nextDouble() * (this.max - this.min) + this.min;
    }

    public int getInt(Random random) {
        return (int)Math.floor(this.get(random));
    }

    public double get(double percent) {
        return this.min + (this.max - this.min) * percent;
    }

    public int getInt(double percent) {
        return (int)Math.floor(this.get(percent));
    }

    public String toString() {
        return "{Range: " + this.min + " - " + this.max + "}";
    }
}

