/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.registration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import yuudaari.soulus.common.CreativeTab;
import yuudaari.soulus.common.compat.jei.IProvidesJeiDescription;
import yuudaari.soulus.common.compat.jei.JeiDescriptionRegistry;

public interface IRegistration<T extends IForgeRegistryEntry<T>>
extends IProvidesJeiDescription,
IForgeRegistryEntry<T> {
    public static final Map<IRegistration<?>, Set<String>> ORE_DICTS = new HashMap();
    public static final Set<IRegistration<?>> REGISTRATIONS_WITH_DESCRIPTIONS = new HashSet();

    public T setCreativeTab(CreativeTabs var1);

    public T setRegistryName(String var1, String var2);

    public T setRegistryName(String var1);

    public T setRegistryName(ResourceLocation var1);

    public ResourceLocation getRegistryName();

    public T setUnlocalizedName(String var1);

    default public T setName(String name) {
        this.setRegistryName("soulus", name);
        this.setUnlocalizedName(this.getRegistryName().toString());
        this.setCreativeTab(CreativeTab.INSTANCE);
        return (T)this;
    }

    default public T addOreDict(String ... dictionaries) {
        Set<String> oreDicts = ORE_DICTS.get(this);
        if (oreDicts == null) {
            oreDicts = new HashSet<String>();
            ORE_DICTS.put(this, oreDicts);
        }
        Arrays.stream(dictionaries).forEach(oreDicts::add);
        return (T)this;
    }

    default public T removeOreDict(String ... dictionaries) {
        Set<String> oreDicts = ORE_DICTS.get(this);
        if (oreDicts == null) {
            oreDicts = new HashSet<String>();
            ORE_DICTS.put(this, oreDicts);
        }
        Arrays.stream(dictionaries).forEach(oreDicts::remove);
        return (T)this;
    }

    default public Set<String> getOreDicts() {
        Set<String> oreDicts = ORE_DICTS.get(this);
        if (oreDicts == null) {
            oreDicts = new HashSet<String>();
            ORE_DICTS.put(this, oreDicts);
        }
        return oreDicts;
    }

    default public T setHasDescription() {
        REGISTRATIONS_WITH_DESCRIPTIONS.add(this);
        return (T)this;
    }

    @Override
    default public void onRegisterDescription(JeiDescriptionRegistry registry) {
        if (!REGISTRATIONS_WITH_DESCRIPTIONS.contains(this)) {
            return;
        }
        Ingredient ing = this.getDescriptionIngredient();
        String name = this.getDescriptionRegistryName();
        Item item = this.getItem();
        if (name == null) {
            registry.add(item);
            return;
        }
        registry.add(ing == null ? Ingredient.func_193367_a((Item)item) : ing, name);
    }

    default public Ingredient getDescriptionIngredient() {
        return null;
    }

    default public String getDescriptionRegistryName() {
        return null;
    }

    public Item getItem();

    default public ItemStack getItemStack() {
        if (this instanceof Item) {
            return new ItemStack((Item)this);
        }
        if (this instanceof Block) {
            return new ItemStack((Block)this);
        }
        throw new IllegalArgumentException("Must be called on a valid Block or Item");
    }

    default public ItemStack getItemStack(Integer count) {
        ItemStack result = this.getItemStack();
        result.func_190920_e(count.intValue());
        return result;
    }

    default public ItemStack getItemStack(Integer count, Integer meta) {
        ItemStack result = this.getItemStack();
        result.func_190920_e(count.intValue());
        result.func_77964_b(meta.intValue());
        return result;
    }

    default public void onRegisterRecipes(IForgeRegistry<IRecipe> registry) {
    }

    @SideOnly(value=Side.CLIENT)
    default public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)((Item)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(((Item)this).getRegistryName(), "inventory"));
    }
}

