/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.recipe.ingredient;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.essence.ConfigEssence;
import yuudaari.soulus.common.config.essence.ConfigEssences;
import yuudaari.soulus.common.item.Essence;
import yuudaari.soulus.common.registration.ItemRegistry;

@ConfigInjected(value="soulus")
public class IngredientPotentialEssence
extends Ingredient {
    @ConfigInjected.Inject
    public static ConfigEssences CONFIG;
    private static IngredientPotentialEssence INSTANCE;
    private static IngredientPotentialEssence INSTANCE_NO_ASH;
    private final boolean allowEmpty;
    private final boolean allowAsh;

    public static IngredientPotentialEssence getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new IngredientPotentialEssence();
        }
        return INSTANCE;
    }

    public static IngredientPotentialEssence getInstanceNoAsh() {
        if (INSTANCE_NO_ASH == null) {
            INSTANCE_NO_ASH = new IngredientPotentialEssence(false, true);
        }
        return INSTANCE_NO_ASH;
    }

    public static ItemStack[] getMatchingStacks1(boolean justEssence) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (!justEssence) {
            stacks.add(ItemStack.field_190927_a);
            stacks.add(ItemRegistry.ASH.getItemStack());
        }
        for (ConfigEssence essenceConfig : IngredientPotentialEssence.CONFIG.essences) {
            if (essenceConfig.essence.equals("NONE")) continue;
            stacks.add(Essence.getStack(essenceConfig.essence));
        }
        return stacks.toArray(new ItemStack[0]);
    }

    public IngredientPotentialEssence() {
        this(true, true);
    }

    public IngredientPotentialEssence(boolean allowAsh, boolean allowEmpty) {
        super(IngredientPotentialEssence.getMatchingStacks1(!allowAsh));
        this.allowAsh = allowAsh;
        this.allowEmpty = allowEmpty;
    }

    public boolean apply(ItemStack input) {
        return this.allowEmpty && (input == null || input.func_190926_b()) || input.func_77973_b() == ItemRegistry.ESSENCE || this.allowAsh && input.func_77973_b() == ItemRegistry.ASH;
    }

    public boolean isSimple() {
        return false;
    }

    static {
        INSTANCE = null;
        INSTANCE_NO_ASH = null;
    }

    public static class Factory
    implements IIngredientFactory {
        public Ingredient parse(JsonContext context, JsonObject json) {
            boolean allowAsh = json.has("allow_ash") ? JsonUtils.func_151212_i((JsonObject)json, (String)"allow_ash") : true;
            boolean allowEmpty = json.has("allow_empty") ? JsonUtils.func_151212_i((JsonObject)json, (String)"allow_ash") : true;
            return new IngredientPotentialEssence(allowAsh, allowEmpty);
        }
    }
}

